﻿using System.Diagnostics;
using System.IO;
using System.Reflection;
using System.Threading.Tasks;

namespace Resonance.Core.Helpers.FileHelpers
{
    public static class FileHelper
    {
        /// <summary>
        /// Expects file to exist
        /// </summary>
        public static long FileLength(string filepath)
        {
            var path = Path.GetFullPath(filepath);
            var directory = Path.GetDirectoryName(path);
            if (!Directory.Exists(directory))
            {
                Directory.CreateDirectory(directory);
            }
            if (!File.Exists(filepath))
            {
                File.WriteAllText(path, "");
            }
            using (var file = new FileStream(filepath, FileMode.Open, FileAccess.Read, FileShare.ReadWrite))
            {
                return file.Length;
            }
        }

        public static string GetRelativePath(string path)
        {
            return Path.Combine(Path.GetDirectoryName(Assembly.GetEntryAssembly().Location), path);
        }

        public static async Task<FileStream> WaitForReadLock(FileInfo fileInfo, int timeout = 300000)
        {
            bool status = false;
            var stopwatch = new Stopwatch();
            FileStream stream = null;
            stopwatch.Start();
            while (!status && stopwatch.ElapsedMilliseconds < timeout)
            {
                try
                {
                    if (!File.Exists(fileInfo.FullName))
                    {
                        return null;
                    }
                    stream = new FileStream(fileInfo.FullName, FileMode.Open, FileAccess.Read, FileShare.Read);
                    status = true;
                    break;
                }
                catch (IOException)
                {
                    await Task.Delay(500);
                }
            }
            stopwatch.Reset();
            return stream;
        }
    }
}
