﻿using Microsoft.AspNetCore.Http;
using Resonance.Core.Helpers.AssetHelpers;
using Resonance.Core.Helpers.DatabaseHelpers;
using Resonance.Core.Helpers.LoggingHelpers;
using Resonance.Core.Models.ApiModels;
using System;
using System.Collections.Generic;
using System.Text;
using System.Linq;
using Resonance.Core.Helpers.FormHelpers;

namespace Resonance.Core.Helpers.FileHelpers
{
    public static class FileUploadHelper
    {
        /* Disabled 2020-05-26 by Nathan, delete after 2020-06-26 if still commented out. Expected flow is through the edit product methods
        public static bool AtlasUploadFile(int productID, ref ApiResponse<EmptyModel> response, IFormCollection form, HttpContext context)
        {
            bool success = false;
            int serverMaxFileArraySize = 100;

            bool productIDExists = false;

            if(productID <= 0 || context == null)
            {
                return false;
            }

            try
            {
                using (var conn = DBManagerMysql.GetConnection(true))
                {
                    using (var command = conn.GetCommand())
                    {
                        command.CommandText = $@"select case when coalesce(product_id, 0) > 0 then True else False end as product_id_exists from {Constants.DatabaseSchema}microservice_twitch_atlas_product where product_id = @productID;";
                        command.Parameters.AddWithValue("@productID", productID);
                        productIDExists = Convert.ToBoolean((long)command.ExecuteScalar());
                    }
                }

                if (productIDExists && AssetHelper.UserHasPermissionToEditProduct(productID, context))
                {
                    var fileErrors = new StringBuilder();
                    var fileCount = form.Files?.Count() ?? 0;
                    if (fileCount > 0)
                    {
                        if (fileCount > serverMaxFileArraySize)
                        {
                            response.ErrorMessage = $"Files uploaded exceeds total allowed. Max allowed: {serverMaxFileArraySize}";
                        }
                        else
                        {
                            foreach (IFormFile file in form.Files)
                            {
                                var bytes = FormFileHelper.ReadFileBytes(file, 8);
                                ProcessFile(productID, file.Name, file.ContentType, bytes, fileErrors);
                            }
                            response.ErrorMessage = fileErrors.ToString().Replace("\r\n", ";");
                        }
                    }
                    else
                    {
                        response.ErrorMessage = "No files found";
                    }
                    if (response.ErrorMessage.Length == 0)
                    {
                        success = true;
                    }
                    else
                    {
                        success = false;
                    }
                }
                else
                {
                    response.ErrorMessage = "Specified product ID does not exist.";
                }
            }
            catch (Exception ex)
            {
                Log.Error(ex);
                response.ErrorMessage = "Error looking up product ID";
            }

            return success;
        }
        */

        public static bool AtlasUploadFile(int productID, string fileName, string fileType, string contentType, ref ApiResponse<EmptyModel> response, string encodedImage, HttpContext context)
        {
            bool success = false;
            bool productIDExists = false;

            if (productID <= 0 || context == null)
            {
                return false;
            }

            try
            {
                using (var conn = DBManagerMysql.GetConnection(true))
                {
                    using (var command = conn.GetCommand())
                    {
                        command.CommandText = $@"select case when coalesce(product_id, 0) > 0 then True else False end as product_id_exists from {Constants.DatabaseSchema}microservice_twitch_atlas_product where product_id = @productID;";
                        command.Parameters.AddWithValue("@productID", productID);
                        productIDExists = Convert.ToBoolean((long)command.ExecuteScalar());
                    }
                }

                if (productIDExists && AssetHelper.UserHasPermissionToEditProduct(productID, context))
                {
                    var fileErrors = new StringBuilder();
                    byte[] image = null;
                    try
                    {
                        image = StringHelpers.StringHelper.Base64DecodeBytes(encodedImage);
                        var result = ProcessFile(productID, fileName, fileType, contentType, image, fileErrors, context);
                        success = response.ErrorMessage == null || response.ErrorMessage.Length == 0;
                    }
                    catch(Exception ex)
                    {
                        Log.Error(ex);
                    }
                }
                else
                {
                    response.ErrorMessage = "Specified product ID does not exist.";
                }
            }
            catch (Exception ex)
            {
                Log.Error(ex);
                response.ErrorMessage = "Error looking up product ID";
            }

            return success;
        }

        private static string ProcessFile(int productID, string fileName, string fileType, string contentType, byte[] file, StringBuilder fileErrors, HttpContext context)
        {
            string keypath = null;

            try
            {
                if(productID <= 0)
                {
                    return null;
                }
                string calcfiletype = string.Empty;
                if(fileType.IndexOf("/") >= 0)
                {
                    calcfiletype = contentType.Substring(contentType.IndexOf("/") + 1);

                }

                switch (contentType)
                {
                    case "image/png":
                    case "image/jpeg":
                    {
                        if (AssetHelper.ValidateImageFile(fileName, contentType, file))
                        {
                            var assetID = AssetHelper.GenerateAssetID();
                            keypath = $@"{Constants.AppConfig.Application.Environment.Substring(0, 1)}/{productID}/images/{fileName}/{assetID}.{calcfiletype}";
                            AssetHelper.SaveImageAssetToS3(productID, assetID, fileName, calcfiletype, contentType, file, "tce-cloudfront-atlas-user-content", keypath, context);
                        }
                        else
                        {
                            fileErrors.AppendLine($"Image validation failed for {fileName}. Please check image specifications to ensure all requirements are met. These include: File size, Min/Max height/width, and that your image has been properly saved as a 'png' or 'jpg' (simply renaming the filetype is not sufficient. It must be 'save as')");
                        }
                        break;
                    }
                    case "video/mp4":
                    {
                        if (AssetHelper.ValidateVideoFile(fileName, file))
                        {
                            var assetID = AssetHelper.GenerateAssetID();
                            keypath = $@"{Constants.AppConfig.Application.Environment.Substring(0, 1)}/{productID}/videos/{fileName}/{assetID}.{calcfiletype}";
                            AssetHelper.SaveVideoAssetToS3(productID, fileName, calcfiletype, assetID, file, "tce-cloudfront-atlas-user-content", keypath, context);
                        }
                        else
                        {
                            fileErrors.AppendLine($"Video validation failed for {fileName}. Please check video specifications to ensure all requirements are met. These include: File size");
                        }

                        break;
                    }
                    default:
                    {
                        fileErrors.AppendLine($"{fileName}{contentType} is an unsupported asset type and will not be processed.");
                        break;
                    }
                }
            }
            catch (Exception ex)
            {
                Log.Error(ex);
                fileErrors.AppendLine($"Error processing {fileName}. Unhandled error, if the error persists please reach out to support.");
            }

            return keypath;
        }
    }
}
