﻿using Microsoft.AspNetCore.Http;
using Resonance.Core.Helpers.LoggingHelpers;
using System;

namespace Resonance.Core.Helpers.FormHelpers
{
    public static class FormFileHelper
    {
        public static byte[] ReadFileBytes(this IFormFile file, long? readOnlyXBytes = null)
        {
            try
            {
                long length = file.Length;
                if(readOnlyXBytes != null)
                {
                    length = readOnlyXBytes.Value;
                }
                if (length < 0)
                {
                    return null;
                }

                byte[] bytes = new byte[length];
                using (var fileStream = file.OpenReadStream())
                {
                    fileStream.Read(bytes, 0, (int)length);
                }
                return bytes;
            }
            catch (Exception ex)
            {
                Log.Error(ex);
                return null;
            }
        }
    }
}
