﻿using Newtonsoft.Json;
using System;
using System.Collections.Generic;
using System.Linq;

namespace Resonance.Core.Helpers.ReflectionHelpers
{
    public static class ReflectionHelper
    {
        public static Dictionary<string, Type> GetTypeJsonPropertyNamesAndTypes<T>()
        {
            var pairs = typeof(T)
                .GetProperties()
                .Select(p => new {
                    Property = p,
                    Attribute = p
                        .GetCustomAttributes(
                            typeof(JsonPropertyAttribute), true)
                        .Cast<JsonPropertyAttribute>()
                        .FirstOrDefault()
                });

            return pairs
                .Where(p => p.Attribute != null)
                .ToDictionary(
                    p => p.Attribute.PropertyName,
                    p => p.Property.PropertyType);
        }
    }
}
