﻿using System;
using System.Collections.Generic;
using System.Text;

namespace Resonance.Core.Helpers.SlackHelpers
{
    public static class EscapeHelper
    {
        /// <summary>
        /// https://api.slack.com/docs/message-formatting
        /// </summary>
        public static string EscapeForSlack(this string data)
        {
            if (string.IsNullOrWhiteSpace(data))
            {
                return string.Empty;
            }

            return
                data
                    .Replace("&", "&amp;")
                    .Replace("<", "&lt;")
                    .Replace(">", "&gt;")
                ;
        }
    }
}
