﻿using Resonance.Core.Helpers.LoggingHelpers;
using System;
using System.Diagnostics;
using System.Net;

namespace Resonance.Core.Helpers.StatsDHelpers
{
    public class StatsDHelper
    {
        private static string _logpath { get; set; }
        public static string AppName { get; set; }
        public static string AppNamespace { get; set; }
        private static statsc.Client _client;
        public static statsc.Client Client
        {
            get
            {
                return _client;
            }
        }

        public static void Initialize(string logpath, string hostName, int port, string appName, string appNamespace, TimeSpan? batchTime = null, string measurementPrefix = "")
        {
            try
            {
                _logpath = logpath;
                AppName = appName.ToLower();
                AppNamespace = appNamespace.ToLower();
                _client = new statsc.Client(serverEndPoint: new DnsEndPoint(hostName, port), metricsNamespace: $"{measurementPrefix}");
            }
            catch (Exception ex)
            {
                Log.Error(ex);
            }
        }

        public static void MeasureActionTime(string measureName, Action action)
        {
            try
            {
                Stopwatch watch = new Stopwatch();
                watch.Start();
                action.Invoke();
                watch.Stop();
                _client.Timer(measureName, watch.Elapsed);
            }
            catch (Exception ex)
            {
                Log.Error(ex);
            }
        }

        public static void Counter(string measurement, string measurementType, int val = 1, string location = "", string fullReplacementKey = null, string additionalTags = null)
        {
            try
            {
                string key = fullReplacementKey ?? $"{measurement.ToLower()},env={Constants.AppConfig.Application.Environment.ToLower()},app={AppName.ToLower()},app_namespace={AppNamespace.ToLower()},location={location.ToLower()},host={Environment.MachineName.ToLower().Replace("-", "_")},measurement_type={measurementType.ToLower()}{additionalTags?.ToLower()?.Replace("-", "_") ?? ""}";
                Log.Verbose($"StatsD: {key}");

                Client.Counter(key, val);
            }
            catch (Exception ex)
            {
                Log.Error(ex);
            }
        }

        public static void CounterLong(string measurement, string measurementType, long val = 1, string location = "", string fullReplacementKey = null, string additionalTags = null)
        {
            try
            {
                string key = fullReplacementKey ?? $"{measurement.ToLower()},env={Constants.AppConfig.Application.Environment.ToLower()},app={AppName.ToLower()},app_namespace={AppNamespace.ToLower()},location={location.ToLower()},host={Environment.MachineName.ToLower().Replace("-", "_")},measurement_type={measurementType.ToLower()}{additionalTags?.ToLower() ?? ""}";
                Log.Verbose($"StatsD: {key}");

                Client.Counter(key, val);
            }
            catch (Exception ex)
            {
                Log.Error(ex);
            }
        }
    }
}
