﻿using System;
using System.Collections.Generic;
using System.Text;

namespace Resonance.Core.Helpers.StringHelpers
{
    public static class HashHelper
    {
        /// <summary>
        /// Taken and edited from https://stackoverflow.com/questions/18645672/how-do-i-create-a-unique-identifier-that-does-not-contain-numbers
        /// </summary>
        public static class SimpleRandomLetterSequence
        {
            private static Random rand;
            private static char minChar = (char)0x0061;
            private static char maxChar = (char)0x007A;

            public static string RandomHash()
            {
                return RandomHash(32);
            }

            public static string RandomHash(int length)
            {
                if (rand == null)
                {
                    rand = new Random();
                }
                var sb = new StringBuilder();
                for (int i = length; i >= 0; i--)
                {
                    sb.Append((char)(rand.Next(minChar, maxChar)));
                }
                return sb.ToString();
            }
        }
    }
}
