﻿using Resonance.Core.Helpers.LoggingHelpers;
using System;
using System.Collections.Generic;
using System.IO;
using System.IO.Compression;
using System.Text;

namespace Resonance.Core.Helpers.StringHelpers
{
    public static class StringHelper
    {
        public static string Truncate(this string source, int length, bool allowNulls = true)
        {
            if(source == null)
            {
                if (allowNulls)
                {
                    return null;
                }
                else
                {
                    return string.Empty;
                }
            }

            if(source.Length <= length)
            {
                return source;
            }
            else
            {
                return source.Substring(0, length);
            }
        }

        public static string GzipBase64Encode(this string source, int? maxstringlength = null)
        {
            try
            {
                if(source == null)
                {
                    return null;
                }
                var buffer = Encoding.UTF8.GetBytes(source);
                using (var memoryStream = new MemoryStream())
                {
                    using (var stream = new GZipStream(memoryStream, CompressionMode.Compress, true))
                    {
                        stream.Write(buffer, 0, buffer.Length);
                    }
                    var content = Convert.ToBase64String(memoryStream.GetBuffer());
                    if (content != null && maxstringlength != null && content.Length <= maxstringlength)
                    {
                        return content;
                    }
                    else if (content != null && maxstringlength != null && content.Length > maxstringlength)
                    {
                        Log.Error($@"GzipBase64Encode Error: {source} exceeds {maxstringlength}");
                        return null;
                    }
                    else
                    {
                        return content;
                    }
                }
            }
            catch (Exception ex)
            {
                Log.Error(ex);
                return null;
            }
        }

        public static string Base64DecodeGzipInflate(this string source)
        {
            string result = null;
            try
            {
                if(source == null)
                {
                    return result;
                }
                using (var stream = new MemoryStream(Convert.FromBase64String(source)))
                {                    
                    using(var gzip = new GZipStream(stream, CompressionMode.Decompress))
                    {
                        using (TextReader reader = new StreamReader(gzip, Encoding.UTF8))
                        {
                            result = reader.ReadToEnd();
                        }
                    }
                }
            }
            catch(Exception ex)
            {
                Log.Error(ex);
            }
            return result;
        }

        public static byte[] Base64DecodeBytes(this string source)
        {
            byte[] result = null;
            try
            {
                result = Convert.FromBase64String(source);
            }
            catch (Exception ex)
            {
                Log.Error(ex);
            }
            return result;
        }

        public static string FormatUsersServiceImageUrl(this string path)
        {
            return !string.IsNullOrEmpty(path) ? path.Replace("%s", "70x70") : path;
        }

    }
}
