﻿using Microsoft.AspNetCore.Antiforgery;
using Microsoft.AspNetCore.Http;
using Microsoft.Extensions.Options;
using Resonance.Core.Helpers.LoggingHelpers;
using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Text;
using System.Threading.Tasks;

namespace Resonance.Core.Middleware
{
    public class ValidateAntiForgeryTokenMiddleware
    {
        private readonly IAntiforgery antiforgery;
        private readonly AntiforgeryOptions options;
        private readonly RequestDelegate next;

        public ValidateAntiForgeryTokenMiddleware(RequestDelegate next, IAntiforgery antiforgery, IOptions<AntiforgeryOptions> options)
        {
            this.next = next;
            this.antiforgery = antiforgery;
            this.options = options.Value;
        }


        public async Task Invoke(HttpContext context)
        {
            /*
            var tokens = antiforgery.GetAndStoreTokens(context);
            context.Response.Cookies.Append("XSRF-Token", tokens.RequestToken, new CookieOptions() { HttpOnly = false });
            */
            var stopwatch = new Stopwatch();
            if (
                HttpMethods.IsPost(context.Request.Method) 
                || HttpMethods.IsPut(context.Request.Method) 
                || HttpMethods.IsPatch(context.Request.Method) 
                || HttpMethods.IsDelete(context.Request.Method)
            )
            {
                stopwatch.Start();
                await antiforgery.ValidateRequestAsync(context);
                stopwatch.Stop();
                Log.Verbose($"Validated anti forgery token in {stopwatch.ElapsedMilliseconds}ms");
            }

            await next(context);
        }
    }
}
