﻿using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Http.Features;
using Microsoft.Extensions.Options;
using Resonance.Core.Helpers.ApiHelpers;
using Resonance.Core.Helpers.LoggingHelpers;
using Resonance.Core.Helpers.StatsDHelpers;
using Resonance.Core.Helpers.StringHelpers;
using Resonance.Core.Models.AuthModels;
using System;
using System.Diagnostics;
using System.Text;
using System.Threading.Tasks;

namespace Resonance.Core.Middleware
{
    public class ConfigurationMiddlewareOptions
    {
    }

    public class ConfigurationMiddleware
    {
        private readonly RequestDelegate _next;
        private readonly ConfigurationMiddlewareOptions _options;

        public ConfigurationMiddleware(RequestDelegate next, IOptions<ConfigurationMiddlewareOptions> options)
        {
            _next = next;
            _options = options.Value;
        }

        public async Task Invoke(HttpContext context)
        {
            try
            {
                context.Response.GetTypedHeaders().CacheControl = new Microsoft.Net.Http.Headers.CacheControlHeaderValue()
                {
                    Public = true,
                    MaxAge = TimeSpan.FromSeconds(30),
                };
                context.Response.Headers[Microsoft.Net.Http.Headers.HeaderNames.Vary] = new string[] { "Accept-Encoding" };
                if (!context.Response.Headers.ContainsKey("ResonanceWorkerVersion"))
                {
                    context.Response.Headers.Add("ResonanceWorkerVersion", Constants.ApplicationVersion);
                }
                else
                {
                    context.Response.Headers["ResonanceWorkerVersion"] = Constants.ApplicationVersion;
                }

                if (!context.Items.ContainsKey("ResonanceVersion"))
                {
                    context.Items.Add("ResonanceVersion", null);
                }
                if (!context.Items.ContainsKey("RequestPath"))
                {
                    context.Items.Add("RequestPath", null);
                }
                if (!context.Items.ContainsKey("RequestMethod"))
                {
                    context.Items.Add("RequestMethod", null);
                }
                context.Items["ResonanceVersion"] = Constants.ApplicationVersion;
                context.Items["RequestPath"] = context.Request.Path;
            }
            catch (Exception ex)
            {
                Log.Error(ex);
            }

            await _next(context);
        }
    }
}
