﻿using Microsoft.AspNetCore.Http;
using Resonance.Core.Helpers.LoggingHelpers;
using System;
using System.Collections.Generic;
using System.IO;
using System.Text;
using System.Threading.Tasks;

namespace Resonance.Core.Middleware
{
    public class DeChunkerMiddleware
    {
        private readonly RequestDelegate _next;

        public DeChunkerMiddleware(RequestDelegate next)
        {
            _next = next;
        }

        public async Task InvokeAsync(HttpContext context)
        {
            var originalBodyStream = context.Response.Body;
            using (var responseBody = new MemoryStream())
            {
                context.Response.Body = responseBody;
                long length = 0;
                context.Response.OnStarting(() =>
                {
                    context.Response.Headers.ContentLength = length;
                    return Task.CompletedTask;
                });
                await _next(context);
                //if you want to read the body, uncomment these lines.
                //context.Response.Body.Seek(0, SeekOrigin.Begin);
                //var body = await new StreamReader(context.Response.Body).ReadToEndAsync();
                length = context.Response.Body.Length;
                if(length == 0)
                {
                    Log.Error($"No Length on request: {context.Request.Path}");
                }
                context.Response.Body.Seek(0, SeekOrigin.Begin);
                await responseBody.CopyToAsync(originalBodyStream);
            }
        }
    }
}
