﻿using Newtonsoft.Json;
using Resonance.Core.Models.ApiModels.TwitchModels;
using System;
using System.Collections.Generic;

namespace Resonance.Core.Models.ApiModels
{
    public class ApiListResponse<T>
    {
        [JsonProperty(PropertyName = "success")]
        public bool Success { get; set; } = false;
        [JsonProperty(PropertyName = "worker_identifier")]
        public string WorkerIdentifier { get; set; } = ConstantsWorker.WorkerIdentifier;
        [JsonProperty(PropertyName = "request_start_time")]
        public DateTime RequestStartTime { get; set; } = DateTime.UtcNow;
        [JsonProperty(PropertyName = "request_end_time")]
        public DateTime? RequestEndTime { get; set; } = null;
        [JsonProperty(PropertyName = "received_records", NullValueHandling = NullValueHandling.Ignore)]
        public long? ReceivedRecords { get; set; } = null;
        [JsonProperty(PropertyName = "processed_records", NullValueHandling = NullValueHandling.Ignore)]
        public long? ProcessedRecords { get; set; } = null;
        [JsonProperty(PropertyName = "data")]
        public IEnumerable<T> ResponseData { get; set; } = null;
        [JsonProperty(PropertyName = "error_message", NullValueHandling = NullValueHandling.Ignore)]
        public string ErrorMessage { get; set; }
        [JsonProperty(PropertyName = "metrics", NullValueHandling = NullValueHandling.Ignore)]
        public ElapsedTimeModel Metrics { get; set; }
    }
}
