﻿using Newtonsoft.Json;
using System;
using System.Collections.Generic;
using System.Text;

namespace Resonance.Core.Models.ApiModels
{
    public class ApiResponse<T>
    {
        [JsonProperty(PropertyName = "success")]
        public bool Success { get; set; } = false;
        [JsonProperty(PropertyName = "worker_identifier")]
        public string WorkerIdentifier { get; set; }
        [JsonProperty(PropertyName = "request_start_time")]
        public DateTime RequestStartTime { get; set; } = DateTime.UtcNow;
        [JsonProperty(PropertyName = "request_end_time")]
        public DateTime? RequestEndTime { get; set; } = null;
        [JsonProperty(PropertyName = "data")]
        public T ResponseData { get; set; } = default(T);
        [JsonProperty(PropertyName = "error_message", NullValueHandling = NullValueHandling.Ignore)]
        public string ErrorMessage { get; set; }
        [JsonProperty(PropertyName = "metrics", NullValueHandling = NullValueHandling.Ignore)]
        public ElapsedTimeModel Metrics { get; set; }
    }
}
