﻿using Newtonsoft.Json;
using Resonance.Core.Models.DatabaseModels.AtlasModels;
using System;
using System.Collections.Generic;
using System.Text;

namespace Resonance.Core.Models.ApiModels.AtlasModels
{
    public class AtlasContractWithChannelList
    {
        [JsonProperty(PropertyName = "contract")]
        public AtlasContract Contract {get;set;}
        [JsonProperty(PropertyName = "account_manager_ids")]
        public IEnumerable<int> AccountManagerIDs { get; set; }
        [JsonProperty(PropertyName = "channels")]
        public IEnumerable<AtlasContractChannelEntry> Channels { get; set; }
    }

    public class AtlasContractChannelEntry
    {
        [JsonProperty(PropertyName = "channel")]
        public string Channel { get; set; }
        [JsonProperty(PropertyName = "channel_id")]
        public long ChannelID { get; set; }
        [JsonProperty(PropertyName = "custom_start_date")]
        public DateTime? CustomStartDate { get; set; }
        [JsonProperty(PropertyName = "custom_end_date")]
        public DateTime? CustomEndDate { get; set; }
    }
}
