﻿using Newtonsoft.Json;
using Resonance.Core.Models.DatabaseModels.AtlasModels;
using System;
using System.Collections.Generic;
using System.Text;

namespace Resonance.Core.Models.ApiModels.AtlasModels
{
    public class ChannelGroupedEventList
    {
        [JsonProperty(PropertyName = "groupings")]
        public List<ChannelGroupedEvent> Groupings { get; set; }
        [JsonProperty(PropertyName = "total_pages")]
        public long TotalPages { get; set; }
    }

    public class ChannelGroupedEvent
    {
        [JsonProperty(PropertyName = "channel_login")]
        public string ChannelLogin { get; set; }
        [JsonProperty(PropertyName = "channel_id")]
        public long ChannelID { get; set; }
        [JsonProperty(PropertyName = "channel_profile_image")]
        public string ChannelProfileImage { get; set; }
        [JsonProperty(PropertyName = "channel_category")]
        public string ChannelCategory { get; set; }
        [JsonProperty(PropertyName = "channel_status")]

        public string ChannelStatus { get; set; }
        [JsonProperty(PropertyName = "viewers")]
        public int Viewers { get; set; }
        [JsonProperty(PropertyName = "events")]
        public List<dynamic> Events { get; set; }
    }


    public class GroupedEventList
    {
        [JsonProperty(PropertyName = "groupings")]
        public List<GroupedEvent> Groupings { get; set; }
        [JsonProperty(PropertyName = "total_pages")]
        public long TotalPages { get; set; }
    }

    public class GroupedEvent
    {
        [JsonProperty(PropertyName = "grouping")]
        public string Grouping { get; set; }
        [JsonProperty(PropertyName = "events")]
        public List<dynamic> Events { get; set; }
    }


    public class CategoryGroupedEventList
    {
        [JsonProperty(PropertyName = "groupings")]
        public List<CategoryGroupedEvent> Groupings { get; set; }
        [JsonProperty(PropertyName = "total_pages")]
        public long TotalPages { get; set; }
    }

    public class CategoryGroupedEvent
    {
        [JsonProperty(PropertyName = "category")]
        public string Category { get; set; }
        [JsonProperty(PropertyName = "viewers")]
        public int Viewers { get; set; }
        [JsonProperty(PropertyName = "tags")]
        public List<string> Tags { get; set; }
        [JsonProperty(PropertyName = "category_image")]
        public string CategoryImage { get; set; }
        [JsonProperty(PropertyName = "events")]
        public List<dynamic> Events { get; set; }
    }

    public class SeasonEventList
    {
        [JsonProperty(PropertyName = "groupings")]
        public List<SeasonGroupedEvent> Groupings { get; set; }
        [JsonProperty(PropertyName = "total_pages")]
        public long TotalPages { get; set; }
    }

    public class SeasonGroupedEvent
    {
        [JsonProperty(PropertyName = "season")]
        public string Season { get; set; }
        [JsonProperty(PropertyName = "events")]
        public List<dynamic> Events { get; set; }
    }

    public class EventCsvRecord
    {
        [CsvHelper.Configuration.Attributes.Name("event_id")]            
        public int EventID { get; set; }        
        [CsvHelper.Configuration.Attributes.Name("season_id")]        
        public int SeasonID { get; set; }
        [CsvHelper.Configuration.Attributes.Name("season_name")]        
        public string SeasonName { get; set; }
        [CsvHelper.Configuration.Attributes.Name("product_id")]        
        public int ProductID { get; set; }
        [CsvHelper.Configuration.Attributes.Name("product_name")]
        public string ProductName { get; set; }
        [CsvHelper.Configuration.Attributes.Name("event_name")]
        public string EventName { get; set; }        
        [CsvHelper.Configuration.Attributes.Name("premium_content_creator_id")]
        public int PremiumContentCreatorID { get; set; }
        [CsvHelper.Configuration.Attributes.Name("premium_content_creator_name")]
         public string PremiumContentCreatorName { get; set; }
        [CsvHelper.Configuration.Attributes.Name("start_time")]
         public DateTime? StartTime { get; set; }
        [CsvHelper.Configuration.Attributes.Name("end_time")]
         public DateTime? EndTime { get; set; }
        [CsvHelper.Configuration.Attributes.Name("topic")]
         public string Topic { get; set; }
        [CsvHelper.Configuration.Attributes.Name("sub_topic")]
         public string SubTopic { get; set; }
        [CsvHelper.Configuration.Attributes.Name("format")]
        public string Format { get; set; }
        [CsvHelper.Configuration.Attributes.Name("sub_format")]
        public string SubFormat { get; set; }
        [CsvHelper.Configuration.Attributes.Name("event_type")]
        public string EventType { get; set; }
        [CsvHelper.Configuration.Attributes.Name("estimated_average_ccv")]
        public float? EstimatedAverageCCV { get; set; }
        [CsvHelper.Configuration.Attributes.Name("pledged_hours_broadcast")]
        public float? PledgedHoursBroadcast { get; set; }
        [CsvHelper.Configuration.Attributes.Name("is_active")]
        public bool IsActive { get; set; }        
        [CsvHelper.Configuration.Attributes.Name("game_name")]
        public string GameName { get; set; }
        [CsvHelper.Configuration.Attributes.Name("distribution")]
        public bool? Distribution { get; set; }
        [CsvHelper.Configuration.Attributes.Name("twitch_involvement")]
        public string TwitchInvolvement { get; set; }
        [CsvHelper.Configuration.Attributes.Name("costreaming_settings")]
        public string CostreamingSettings { get; set; }        
        [CsvHelper.Configuration.Attributes.Name("created_user")]
        public string CreatedUser { get; set; }
        [CsvHelper.Configuration.Attributes.Name("created_time")]
        public DateTime CreatedTime { get; set; }
        [CsvHelper.Configuration.Attributes.Name("updated_time")]
        public string UpdatedUser { get; set; }
        [CsvHelper.Configuration.Attributes.Name("updated_time")]
        public DateTime? UpdatedTime { get; set; }
        [CsvHelper.Configuration.Attributes.Name("channel_ids")]
        public string ChannelIDs { get; set; }
        [CsvHelper.Configuration.Attributes.Name("channel_names")]
        public string ChannelNames { get; set; }
    }
}
