﻿using Newtonsoft.Json;
using Resonance.Core.Models.DatabaseModels.AtlasModels;
using System;
using System.Collections.Generic;
using System.Text;

namespace Resonance.Core.Models.ApiModels.AtlasModels
{
    public class AtlasEventWithStreamList
    {
        [JsonProperty(PropertyName = "event")]
        public AtlasEvent Event { get; set; }
        [JsonProperty(PropertyName = "streams")]
        public IEnumerable<EventStreamEntry> Streams { get; set; }
        [CsvHelper.Configuration.Attributes.Name("time_zone")]
        [JsonProperty(PropertyName = "time_zone")]
        public string TimeZone { get; set; }
    }

    public class EventStreamEntry
    {
        [JsonProperty(PropertyName = "channel")]
        public string Channel { get; set; }
        [JsonProperty(PropertyName = "channel_id")]
        public long ChannelID { get; set; }
        [JsonProperty(PropertyName = "channel_type")]
        public string Type { get; set; }
    }
}
