﻿using Newtonsoft.Json;
using System;
using System.Collections.Generic;
using System.Text;

namespace Resonance.Core.Models.ApiModels.TwitchModels
{
    public class CheermoteActions
    {
        [JsonProperty(PropertyName = "actions")]
        public List<Action> Actions { get; set; }
    }

    public class ThemedImage
    {
        [JsonProperty(PropertyName = "animated")]
        public Dictionary<string, string> Animated { get; set; }
        [JsonProperty(PropertyName = "static")]
        public Dictionary<string, string> Static { get; set; }
    }

    public class Images
    {
        [JsonProperty(PropertyName = "dark")]
        public ThemedImage Dark { get; set; }
        [JsonProperty(PropertyName = "light")]
        public ThemedImage Light { get; set; }
    }

    public class Tier
    {
        [JsonProperty(PropertyName = "min_bits")]
        public int MinBits { get; set; }
        [JsonProperty(PropertyName = "id")]
        public string ID { get; set; }
        [JsonProperty(PropertyName = "color")]
        public string Color { get; set; }
        [JsonProperty(PropertyName = "images")]
        public Images Images { get; set; }
        [JsonProperty(PropertyName = "can_cheer")]
        public bool CanCheer { get; set; }
        [JsonProperty(PropertyName = "show_in_bits_card")]
        public bool ShowInBitsCard { get; set; }
    }

    public class Action
    {
        [JsonProperty(PropertyName = "prefix")]
        public string Prefix { get; set; }
        [JsonProperty(PropertyName = "scales")]
        public List<string> Scales { get; set; }
        [JsonProperty(PropertyName = "tiers")]
        public List<Tier> Tiers { get; set; }
        [JsonProperty(PropertyName = "backgrounds")]
        public List<string> Backgrounds { get; set; }
        [JsonProperty(PropertyName = "states")]
        public List<string> States { get; set; }
        [JsonProperty(PropertyName = "type")]
        public string Type { get; set; }
        [JsonProperty(PropertyName = "order")]
        public int Order { get; set; }
        [JsonProperty(PropertyName = "last_updated")]
        public object LastUpdates { get; set; }
        [JsonProperty(PropertyName = "is_charitable")]
        public bool IsCharitable { get; set; }
    }
}
