﻿using Newtonsoft.Json;
using System;
using System.Collections.Generic;
using System.Text;

namespace Resonance.Core.Models.ApiModels.TwitchModels
{
    public class TenureBadgeSets
    {
        [JsonProperty(PropertyName = "badge_sets")]
        public TwitchTenureBadges TenureBadges { get; set; }
    }

    public class TwitchTenureBadges
    {
        [JsonProperty(PropertyName = "subscriber")]
        public SubscriberBadges SubscriberBadges { get; set; }
    }

    public class SubscriberBadges
    {
        [JsonProperty(PropertyName = "versions")]
        public Dictionary<string, Badge> Badges { get; set; }
    }

    public class Badge
    {
        [JsonProperty(PropertyName = "image_url_1x")]
        public string Small { get; set; }
        [JsonProperty(PropertyName = "image_url_2x")]
        public string Medium { get; set; }
        [JsonProperty(PropertyName = "image_url_4x")]
        public string Large { get; set; }
        [JsonProperty(PropertyName = "description")]
        public string Description { get; set; }
        [JsonProperty(PropertyName = "title")]
        public string Title { get; set; }
        [JsonProperty(PropertyName = "click_action")]
        public string ClickAction { get; set; }
        [JsonProperty(PropertyName = "click_url")]
        public string ClickUrl { get; set; }
        [JsonProperty(PropertyName = "last_updated")]
        public DateTime? LastUpdated { get; set; }
    }
}
