﻿using Newtonsoft.Json;
using Resonance.Core.Models.ApiModels.SalesforceModels;
using Resonance.Core.Models.ServiceModels.TwitchModels;
using System;
using System.Collections.Generic;
using System.Text;

namespace Resonance.Core.Models.ApiModels.TwitchModels
{
    public class ChannelDetailsModel
    {
        [JsonProperty(PropertyName = "max_date")]
        public DateTime MaxDate { get; set; }
        [JsonProperty(PropertyName = "login")]
        public string Login { get; set; }
        [JsonProperty(PropertyName = "channel_id")]
        public long ChannelID { get; set; }
        [JsonProperty(PropertyName = "ccu_tier")]
        public string CCUTier { get; set; }
        [JsonProperty(PropertyName = "last_broadcast_date")]
        public DateTime LastBroadcastDate { get; set; }
        [JsonProperty(PropertyName = "user_type")]
        public string UserType { get; set; }
        [JsonProperty(PropertyName = "subs_total")]
        public long SubsTotal { get; set; }
        [JsonProperty(PropertyName = "follower_count_total")]
        public long FollowerCountTotal { get; set; }
        [JsonProperty(PropertyName = "profile_image")]
        public string ProfileImage { get; set; }
        [JsonProperty(PropertyName = "account_manager_user_name")]
        public string AccountManagerUserName { get; set; }
        [JsonProperty(PropertyName = "account_manager_full_name")]
        public string AccountManagerFullName { get; set; }
        [JsonProperty(PropertyName = "minutes_watched_data")]
        public string MinutesWatchedData { get; set; }
        [JsonProperty(PropertyName = "average_ccu_data")]
        public string AverageCCUData { get; set; }
        [JsonProperty(PropertyName = "revenue_data")]
        public string RevenueData { get; set; }
        [JsonProperty(PropertyName = "sub_data")]
        public string MonthlySubsData { get; set; }
        [JsonProperty(PropertyName = "clips")]
        public Dictionary<string, List<ChannelDetailsClip>> Clips { get; set; }
        [JsonProperty(PropertyName = "streams")]
        public List<ChannelDetailsStream> Streams { get; set; }
        [JsonProperty(PropertyName = "scorecard")]
        public UserScorecardModel Scorecard { get; set; }
        [JsonProperty(PropertyName = "tims")]
        public UserTimsModel Tims { get; set; }
        [JsonProperty(PropertyName = "calendar")]
        public TwitchUserCalendarDisplayModel Calendar { get; set; }
        [JsonProperty(PropertyName = "viewbot")]
        public TwitchViewbotModel Viewbot { get; set; }
        [JsonProperty(PropertyName = "path_to_affiliate")]
        public DateTime? PathToAffiliateDate { get; set; }
        [JsonProperty(PropertyName = "path_to_partner")]
        public DateTime? PathToPartnerDate { get; set; }
        [JsonProperty(PropertyName = "weekly_summary")]
        public TwitchUserWeeklySummaryModel WeeklySummary { get; set; }
        [JsonProperty(PropertyName = "top_countries")]
        public ChannelCountry TopCountries { get; set; }
        [JsonProperty(PropertyName = "tenure_badges")]
        public Dictionary<string, Badge> TenureBadges { get; set; }
        [JsonProperty(PropertyName = "emotes")]
        public List<TwitchEmoteDisplayModel> Emotes { get; set; }
        [JsonProperty(PropertyName = "cheermotes")]
        public Dictionary<string, Dictionary<string, CheermoteDisplayModel>> Cheermotes { get; set; }
        [JsonProperty(PropertyName = "partner_applications")]
        public IEnumerable<UserCase> PartnerApplications { get; set; }
        [JsonProperty(PropertyName = "value_score_overall_weighted")]
        public float ValueScoreOverallWeighted { get; set; }
    }

    public class ChannelDetailsClip
    {
        [JsonProperty(PropertyName = "title")]
        public string Title { get; set; }
        [JsonProperty(PropertyName = "created")]
        public DateTime Created { get; set; }
        [JsonProperty(PropertyName = "thumbnail")]
        public string Thumbnail { get; set; }
        [JsonProperty(PropertyName = "views")]
        public long Views { get; set; }
        [JsonProperty(PropertyName = "url")]
        public string Url { get; set; }
    }

    public class ChannelCountry
    {
        [JsonProperty(PropertyName = "total_count")]
        public long? TotalCount { get; set; }
        [JsonProperty(PropertyName = "known_count")]
        public long? TotalKnownCount { get; set; }
        [JsonProperty(PropertyName = "unknown_count")]
        public long? TotalUnknownCount { get; set; }
        [JsonProperty(PropertyName = "known_percent")]
        public float? TotalKnownPercent { get; set; }
        [JsonProperty(PropertyName = "unknown_percent")]
        public float? TotalUnknownPercent { get; set; }
        [JsonProperty(PropertyName = "last_update_date")]
        public DateTime? LastUpdateDate { get; set; }
        [JsonProperty(PropertyName = "details")]
        public List<ChannelCountryDetails> CountryDetails { get; set; }
    }

    public class ChannelCountryDetails
    {
        [JsonProperty(PropertyName = "country_code")]
        public string CountryCode { get; set; }
        [JsonProperty(PropertyName = "country_name")]
        public string CountryName { get; set; }
        [JsonProperty(PropertyName = "country_percent")]
        public float? CountryPercent { get; set; }
        [JsonProperty(PropertyName = "rank")]
        public int? Rank { get; set; }
    }

    public class ChannelDetailsStream
    {
        [JsonProperty(PropertyName = "title")]
        public string Title { get; set; }
        [JsonProperty(PropertyName = "start_date")]
        public DateTime StartDate { get; set; }
        [JsonProperty(PropertyName = "end_date")]
        public DateTime EndDate { get; set; }
        [JsonProperty(PropertyName = "thumbnail")]
        public string Thumbnail { get; set; }
        [JsonProperty(PropertyName = "views")]
        public long Views { get; set; }
        [JsonProperty(PropertyName = "avgccv")]
        public double AverageCCU { get; set; }
        [JsonProperty(PropertyName = "peakccv")]
        public double PeakCCU { get; set; }
        [JsonProperty(PropertyName = "followers")]
        public long Followers { get; set; }
        [JsonProperty(PropertyName = "categories")]
        public HashSet<string> Categories { get; set; }
        [JsonIgnore]
        public List<string> BroadcastIDs { get; set; }
        [JsonProperty(PropertyName = "timeago")]
        public string TimeAgo
        {
            get
            {
                var timeDiff = (DateTime.UtcNow - StartDate);
                List<string> parts = new List<string>();
                if(timeDiff.Days > 0)
                {
                    parts.Add($"{timeDiff.Days}D");
                }
                if (timeDiff.Hours > 0)
                {
                    parts.Add($"{timeDiff.Hours}H");
                }
                return string.Join(' ', parts.ToArray());

            }

        }
        [JsonProperty(PropertyName = "drop_in_url")]
        public string DropInUrl { get; set; }
    }
}
