﻿using Newtonsoft.Json;
using System;
using System.Collections;
using System.Collections.Generic;
using System.Linq;
using System.Reflection;
using static Resonance.Core.Constants;

namespace Resonance.Core.Models.ApiModels.TwitchModels
{
    public class UserScorecardModel
    {
        [JsonProperty(PropertyName = "twitch_user_id")]
        public long TwitchUserID { get; set; }
        [JsonProperty(PropertyName = "login")]
        public string Login { get; set; }
        [JsonProperty(PropertyName = "data_sourced")]
        public DateTime DataSourced { get; set; }
        [JsonProperty(PropertyName = "item_count")]
        public int ItemCount
        {
            get
            {
                return ScorecardTask?.Count() ?? 0;
            }
        }
        [JsonProperty(PropertyName = "item_complete_count")]
        public int ItemsComplete
        {
            get
            {
                return (ScorecardTask?.Where(x => x.IsComplete)?.Count()) ?? 0;
            }
        }
        [JsonProperty(PropertyName = "score")]
        public double Score
        {
            get
            {
                return Convert.ToDouble(this.ItemsComplete) / Convert.ToDouble(this.ItemCount) * 100.0d;
            }
        }
        [JsonProperty(PropertyName = "tasks")]
        public List<ScorecardTaskModel> ScorecardTask { get; set; }
    }

    public class ScorecardTaskModel
    {
        [JsonProperty(PropertyName = "name")]
        public string Name{ get; set; }
        [JsonProperty(PropertyName = "title")]
        public string DisplayName { get; set; }
        [JsonProperty(PropertyName = "description")]
        public string Description { get; set; }
        [JsonProperty(PropertyName = "recommended_action")]
        public string RecommendedAction { get; set; }
        [JsonProperty(PropertyName = "is_complete")]
        public bool IsComplete { get; set; }
        [JsonProperty(PropertyName = "is_manual")]
        public bool IsManual { get; set; }
        [JsonProperty(PropertyName = "priority")]
        public ScorecardPriority Priority { get; set; }
    }
}
