﻿using Newtonsoft.Json;
using System;
using System.Collections.Generic;

namespace Resonance.Core.Models.AuthModels
{
    public class AuthPermittedModel
    {
        /// <summary>
        /// Did all auth checks pass
        /// </summary>
        [CsvHelper.Configuration.Attributes.Name("is_verified")]
        [JsonProperty(PropertyName = "is_verified")]
        public bool IsVerified { get; set; } = false;
        /// <summary>
        /// Status code based on verify user result
        /// </summary>
        [CsvHelper.Configuration.Attributes.Name("status_code")]
        [JsonProperty(PropertyName = "status_code")]
        public int StatusCode { get; set; } = 200;
        /// <summary>
        /// Overall error message
        /// </summary>
        [CsvHelper.Configuration.Attributes.Name("error_message")]
        [JsonProperty(PropertyName = "error_message")]
        public string ErrorMessage { get; set; } = String.Empty;
        /// <summary>
        /// Premium Content Creator ID, Status Code
        /// </summary>
        [CsvHelper.Configuration.Attributes.Name("auth_results")]
        [JsonProperty(PropertyName = "auth_results")]
        public Dictionary<int, int> AuthResults { get; set; } = new Dictionary<int, int>();
    }
}
