﻿using Microsoft.AspNetCore.Authorization;
using NodaTime;
using NodaTime.Extensions;
using System;
using System.Collections.Generic;
using System.Text;
using System.Threading.Tasks;

namespace Resonance.Core.Models.AuthModels
{
    public class MinimumMonthsEmployedRequirement : IAuthorizationRequirement
    {
        public int MinimumMonthsEmployed { get; private set; }

        public MinimumMonthsEmployedRequirement(int minimumMonths)
        {
            this.MinimumMonthsEmployed = minimumMonths;
        }
    }

    public class MinimumMonthsEmployedHandler : AuthorizationHandler<MinimumMonthsEmployedRequirement>
    {
        protected override Task HandleRequirementAsync(AuthorizationHandlerContext context, MinimumMonthsEmployedRequirement requirement)
        {
            var employmentCommenced = context.User
                .FindFirst(claim => claim.Type == CustomClaimTypes.EmploymentCommenced).Value;

            var employmentStarted = Convert.ToDateTime(employmentCommenced);
            var today = LocalDate.FromDateTime(DateTime.Now);

            var monthsPassed = Period
                .Between(employmentStarted.ToLocalDateTime(), today.AtMidnight())
                .Months;

            if (monthsPassed >= requirement.MinimumMonthsEmployed)
            {
                context.Succeed(requirement);
            }

            return Task.CompletedTask;
        }
    }

    public static class CustomClaimTypes
    {
        public const string EmploymentCommenced = "EmploymentCommenced";
    }
}
