﻿using Amazon.SecurityToken.Model;
using System;

namespace Resonance.Core.Models.ConfigurationModels.Aws
{
    public class AwsCredentialModel
    {
        public string AccessKeyId { get; set; }
        public string SecretAccessKey { get; set; }
        public string SessionToken { get; set; }
        public DateTime Expiration { get; set; }

        public AwsCredentialModel(GetSessionTokenResponse token)
        {
            if(token == null || token.Credentials == null)
            {
                return;
            }

            AccessKeyId = token.Credentials.AccessKeyId;
            SecretAccessKey = token.Credentials.SecretAccessKey;
            SessionToken = token.Credentials.SessionToken;
            Expiration = token.Credentials.Expiration;
        }
    }
}
