﻿using System;
using static Resonance.Core.Constants;

namespace Resonance.Core.Models.ConfigurationModels.Jobs
{
    public class DataQualityConfiguration
    {
        public int TaskCompletionTimeout = 86400000;

        public AggregationType[] RequiredAggregations = new AggregationType[5]
        {
            AggregationType.Week,
            AggregationType.ThirtyDay,
            AggregationType.SixtyDay,
            AggregationType.NintyDay,
            AggregationType.BankerYear
        };

        public string[] ApiEndpoints = new string[2]
        {
            $"{Constants.AppConfig.Endpoints.Auth}",
            $"{Constants.AppConfig.Endpoints.Amp}"
        };

        public int LowerPopulationThreshold = 5000;
        public int MaxAgeOfData = 3;
        public int DuplcationFoundTolerance = 1;
    }
}
