﻿using Newtonsoft.Json;
using System.Collections.Generic;

namespace Resonance.Core.Models.ConfigurationModels.Permissions
{
    public class PermissionConfigurationModel
    {
        [JsonProperty(PropertyName = "permissions")]
        public List<PermissionModel> Permissions { get; set; }
        [JsonProperty(PropertyName = "tokens")]
        public List<TokenModel> Tokens { get; set; }
        [JsonProperty(PropertyName = "roles")]
        public List<RoleModel> Roles { get; set; }
        [JsonProperty(PropertyName = "ldap-groups")]
        public List<LdapGroupModel> LdapGroups { get; set; }
        [JsonProperty(PropertyName = "ldap-names")]
        public List<LdapNameModel> LdapNames { get; set; }
        [JsonProperty(PropertyName = "column-permissions")]
        public List<ColumnPermissionModel> ColumnPermissions { get; set; }
        [JsonProperty(PropertyName = "role-to-ldap-group-map")]
        public Dictionary<string, List<string>> RoleToLdapGroupMap { get; set; }
        [JsonProperty(PropertyName = "role-to-ldap-name-map")]
        public Dictionary<string, List<string>> RoleToLdapNameMap { get; set; }
        [JsonProperty(PropertyName = "role-to-permission-map")]
        public Dictionary<string, List<string>> RoleToPermissionMap { get; set; }
        [JsonProperty(PropertyName = "role-to-token-map")]
        public Dictionary<string, List<string>> RoleToTokenMap { get; set; }   
        public List<string> ColumnList { get; set; }

        public PermissionConfigurationModel()
        {
            ColumnList = new List<string>();
        }
    }
}
