﻿using Newtonsoft.Json;
using System;

namespace Resonance.Core.Models.DatabaseModels.AtlasModels
{
    public class AtlasContract
    {
        [CsvHelper.Configuration.Attributes.Name("contract_id")]
        [JsonProperty(PropertyName = "contract_id")]
        public int ContractID { get; set; }
        [CsvHelper.Configuration.Attributes.Name("contract_name")]
        [JsonProperty(PropertyName = "contract_name")]
        public string ContractName { get; set; }
        [CsvHelper.Configuration.Attributes.Name("contract_type")]
        [JsonProperty(PropertyName = "contract_type")]
        public string ContractType { get; set; }
        [CsvHelper.Configuration.Attributes.Name("premium_content_creator_id")]
        [JsonProperty(PropertyName = "premium_content_creator_id")]
        public int PremiumContentCreatorID { get; set; }
        [CsvHelper.Configuration.Attributes.Name("start_date")]
        [JsonProperty(PropertyName = "start_date")]
        public DateTime StartDate { get; set; }
        [CsvHelper.Configuration.Attributes.Name("end_date")]
        [JsonProperty(PropertyName = "end_date")]
        public DateTime EndDate { get; set; }
        [CsvHelper.Configuration.Attributes.Name("revenue_share_enabled")]
        [JsonProperty(PropertyName = "revenue_share_enabled")]
        public bool RevenueShareEnabled { get; set; }
        [CsvHelper.Configuration.Attributes.Name("ad_revenue_contract_type")]
        [JsonProperty(PropertyName = "ad_revenue_contract_type")]
        public string AdRevenueContractType { get; set; }
        [CsvHelper.Configuration.Attributes.Name("ad_revenue_share_type_tier_1")]
        [JsonProperty(PropertyName = "ad_revenue_share_type_tier_1")]
        public string AdRevenueShareTypeTier1 { get; set; }
        [CsvHelper.Configuration.Attributes.Name("ad_revenue_share_amount_tier_1")]
        [JsonProperty(PropertyName = "ad_revenue_share_amount_tier_1")]
        public float AdRevenueShareAmountTier1 { get; set; }
        [CsvHelper.Configuration.Attributes.Name("ad_revenue_share_type_tier_2")]
        [JsonProperty(PropertyName = "ad_revenue_share_type_tier_2")]
        public string AdRevenueShareTypeTier2 { get; set; }
        [CsvHelper.Configuration.Attributes.Name("ad_revenue_share_amount_tier_2")]
        [JsonProperty(PropertyName = "ad_revenue_share_amount_tier_2")]
        public float AdRevenueShareAmountTier2 { get; set; }
        [CsvHelper.Configuration.Attributes.Name("ad_revenue_share_type_tier_3")]
        [JsonProperty(PropertyName = "ad_revenue_share_type_tier_3")]
        public string AdRevenueShareTypeTier3 { get; set; }
        [CsvHelper.Configuration.Attributes.Name("ad_revenue_share_amount_tier_3")]
        [JsonProperty(PropertyName = "ad_revenue_share_amount_tier_3")]
        public float AdRevenueShareAmountTier3 { get; set; }
        [CsvHelper.Configuration.Attributes.Name("bits_revenue_share_percent")]
        [JsonProperty(PropertyName = "bits_revenue_share_percent")]
        public float BitsRevenueSharePercent { get; set; }
        [CsvHelper.Configuration.Attributes.Name("subs_revenue_share_percent")]
        [JsonProperty(PropertyName = "subs_revenue_share_percent")]
        public float SubsRevenueSharePercent { get; set; }
        [CsvHelper.Configuration.Attributes.Name("ad_density_per_hour")]
        [JsonProperty(PropertyName = "ad_density_per_hour")]
        public float AdDensityPerHour { get; set; }
        [CsvHelper.Configuration.Attributes.Name("exclusivity_enabled")]
        [JsonProperty(PropertyName = "exclusivity_enabled")]
        public bool ExclusivityEnabled { get; set; }
        [CsvHelper.Configuration.Attributes.Name("ad_prerolls_enabled")]
        [JsonProperty(PropertyName = "ad_prerolls_enabled")]
        public bool AdPrerollsEnabled { get; set; }
        [CsvHelper.Configuration.Attributes.Name("sponsorship_enabled")]
        [JsonProperty(PropertyName = "sponsorship_enabled")]
        public bool SponsorshipEnabled { get; set; }
        [CsvHelper.Configuration.Attributes.Name("is_active")]
        [JsonProperty(PropertyName = "is_active")]
        public bool IsActive { get; set; }
        [CsvHelper.Configuration.Attributes.Name("created_time")]
        [JsonProperty(PropertyName = "created_time")]
        public DateTime CreatedTime { get; set; }
        [CsvHelper.Configuration.Attributes.Name("created_user")]
        [JsonProperty(PropertyName = "created_user")]
        public string CreatedUser { get; set; }
        [CsvHelper.Configuration.Attributes.Name("additional_notes")]
        [JsonProperty(PropertyName = "additional_notes")]
        public string AdditionalNotes { get; set; }
        [CsvHelper.Configuration.Attributes.Name("document_link")]
        [JsonProperty(PropertyName = "document_link")]
        public string DocumentLink { get; set; }
        [CsvHelper.Configuration.Attributes.Name("auto_renew")]
        [JsonProperty(PropertyName = "auto_renew")]
        public bool AutoRenew { get; set; }
        [CsvHelper.Configuration.Attributes.Name("original_start_date")]
        [JsonProperty(PropertyName = "original_start_date")]
        public DateTime? OriginalStartDate { get; set; }
        [CsvHelper.Configuration.Attributes.Name("original_end_date")]
        [JsonProperty(PropertyName = "original_end_date")]
        public DateTime? OriginalEndDate { get; set; }
    }
}
