﻿using Newtonsoft.Json;
using System;

namespace Resonance.Core.Models.DatabaseModels.AtlasModels
{
    /// <summary>
    /// Edits here should be reflected on ProductEditModal and ViewAtlasProduct
    /// </summary>
    public class AtlasProduct
    {
        [CsvHelper.Configuration.Attributes.Name("product_id")]
        [JsonProperty(PropertyName = "product_id")]
        public int ProductID { get; set; }
        [CsvHelper.Configuration.Attributes.Name("product_name")]
        [JsonProperty(PropertyName = "product_name")]
        public string ProductName { get; set; }
        [CsvHelper.Configuration.Attributes.Name("product_description")]
        [JsonProperty(PropertyName = "product_description")]
        public string ProductDescription { get; set; }
        [CsvHelper.Configuration.Attributes.Name("product_owner")]
        [JsonProperty(PropertyName = "product_owner")]
        public string ProductOwner { get; set; }
        [CsvHelper.Configuration.Attributes.Name("topic")]
        [JsonProperty(PropertyName = "topic")]
        public string Topic { get; set; }
        [CsvHelper.Configuration.Attributes.Name("sub_topic")]
        [JsonProperty(PropertyName = "sub_topic")]
        public string SubTopic { get; set; }
        [CsvHelper.Configuration.Attributes.Name("format")]
        [JsonProperty(PropertyName = "format")]
        public string Format { get; set; }
        [CsvHelper.Configuration.Attributes.Name("sub_format")]
        [JsonProperty(PropertyName = "sub_format")]
        public string SubFormat { get; set; }
        [CsvHelper.Configuration.Attributes.Name("is_active")]
        [JsonProperty(PropertyName = "is_active")]
        public bool IsActive { get; set; } = true;
        [CsvHelper.Configuration.Attributes.Name("created_time")]
        [JsonProperty(PropertyName = "created_time")]
        public DateTime? CreatedTime { get; set; }
        [CsvHelper.Configuration.Attributes.Name("created_user")]
        [JsonProperty(PropertyName = "created_user")]
        public string CreatedUser { get; set; }
        [CsvHelper.Configuration.Attributes.Name("premium_content_creator_id")]
        [JsonProperty(PropertyName = "premium_content_creator_id")]
        public int PremiumContentCreatorID { get; set; }
    }
}
