﻿using Newtonsoft.Json;
using System;

namespace Resonance.Core.Models.DatabaseModels.AtlasModels
{
    public class AtlasSeason
    {
        [CsvHelper.Configuration.Attributes.Name("season_id")]
        [JsonProperty(PropertyName = "season_id")]
        public int SeasonID { get; set; }
        [CsvHelper.Configuration.Attributes.Name("product_id")]
        [JsonProperty(PropertyName = "product_id")]
        public int ProductID { get; set; }
        [CsvHelper.Configuration.Attributes.Name("season_name")]
        [JsonProperty(PropertyName = "season_name")]
        public string SeasonName { get; set; }
        [CsvHelper.Configuration.Attributes.Name("start_time")]
        [JsonProperty(PropertyName = "start_time")]
        public DateTime? StartTime { get; set; }
        [CsvHelper.Configuration.Attributes.Name("end_time")]
        [JsonProperty(PropertyName = "end_time")]
        public DateTime? EndTime { get; set; }
        [CsvHelper.Configuration.Attributes.Name("pledged_hours_broadcast")]
        [JsonProperty(PropertyName = "pledged_hours_broadcast")]
        public float? PledgedHoursBroadcast { get; set; }
        [CsvHelper.Configuration.Attributes.Name("prize_pool")]
        [JsonProperty(PropertyName = "prize_pool")]
        public float? PrizePool { get; set; }
        [CsvHelper.Configuration.Attributes.Name("is_active")]
        [JsonProperty(PropertyName = "is_active")]
        public bool IsActive { get; set; } = true;
        [CsvHelper.Configuration.Attributes.Name("created_time")]
        [JsonProperty(PropertyName = "created_time")]
        public DateTime? CreatedTime { get; set; }
        [CsvHelper.Configuration.Attributes.Name("created_user")]
        [JsonProperty(PropertyName = "created_user")]
        public string CreatedUser { get; set; }
        [CsvHelper.Configuration.Attributes.Name("previous_season_id")]
        [JsonProperty(PropertyName = "previous_season_id")]
        public int? PreviousSeasonID { get; set; }
        [CsvHelper.Configuration.Attributes.Name("previous_season_name")]
        [JsonProperty(PropertyName = "previous_season_name")]
        public string PreviousSeasonName { get; set; }
    }
}
