﻿using Newtonsoft.Json;
using System;

namespace Resonance.Core.Models.DatabaseModels.AtlasModels
{
    public class ViewContractChannel
    {
        [CsvHelper.Configuration.Attributes.Name("contract_id")]
        [JsonProperty(PropertyName = "contract_id")]
        public int ContractID { get; set; }
        [CsvHelper.Configuration.Attributes.Name("contract_name")]
        [JsonProperty(PropertyName = "contract_name")]
        public string ContractName { get; set; }
        [CsvHelper.Configuration.Attributes.Name("contract_type")]
        [JsonProperty(PropertyName = "contract_type")]
        public string ContractType { get; set; }
        [CsvHelper.Configuration.Attributes.Name("contract_start_date")]
        [JsonProperty(PropertyName = "contract_start_date")]
        public DateTime ContractStartDate { get; set; }
        [CsvHelper.Configuration.Attributes.Name("contract_end_date")]
        [JsonProperty(PropertyName = "contract_end_date")]
        public DateTime ContractEndDate { get; set; }
        [CsvHelper.Configuration.Attributes.Name("revenue_share_enabled")]
        [JsonProperty(PropertyName = "revenue_share_enabled")]
        public bool RevenueShareEnabled { get; set; }
        [CsvHelper.Configuration.Attributes.Name("ad_revenue_contract_type")]
        [JsonProperty(PropertyName = "ad_revenue_contract_type")]
        public string AdRevenueContractType { get; set; }
        [CsvHelper.Configuration.Attributes.Name("ad_revenue_share_type_tier_1")]
        [JsonProperty(PropertyName = "ad_revenue_share_type_tier_1")]
        public string AdRevenueShareTypeTier1 { get; set; }
        [CsvHelper.Configuration.Attributes.Name("ad_revenue_share_amount_tier_1")]
        [JsonProperty(PropertyName = "ad_revenue_share_amount_tier_1")]
        public float AdRevenueShareTypeAmount1 { get; set; }
        [CsvHelper.Configuration.Attributes.Name("ad_revenue_share_type_tier_2")]
        [JsonProperty(PropertyName = "ad_revenue_share_type_tier_2")]
        public string AdRevenueShareTypeTier2 { get; set; }
        [CsvHelper.Configuration.Attributes.Name("ad_revenue_share_amount_tier_2")]
        [JsonProperty(PropertyName = "ad_revenue_share_amount_tier_2")]
        public float AdRevenueShareTypeAmount2 { get; set; }
        [CsvHelper.Configuration.Attributes.Name("ad_revenue_share_type_tier_3")]
        [JsonProperty(PropertyName = "ad_revenue_share_type_tier_3")]
        public string AdRevenueShareTypeTier3 { get; set; }
        [CsvHelper.Configuration.Attributes.Name("ad_revenue_share_amount_tier_3")]
        [JsonProperty(PropertyName = "ad_revenue_share_amount_tier_3")]
        public float AdRevenueShareTypeAmount3 { get; set; }
        [CsvHelper.Configuration.Attributes.Name("bits_revenue_share_percent")]
        [JsonProperty(PropertyName = "bits_revenue_share_percent")]
        public float BitsRevenueSharePercent { get; set; }
        [CsvHelper.Configuration.Attributes.Name("subs_revenue_share_percent")]
        [JsonProperty(PropertyName = "subs_revenue_share_percent")]
        public float SubsRevenueSharePercent { get; set; }
        [CsvHelper.Configuration.Attributes.Name("ad_density_per_hour")]
        [JsonProperty(PropertyName = "ad_density_per_hour")]
        public float AdDensityPerHour { get; set; }
        [CsvHelper.Configuration.Attributes.Name("exclusivity_enabled")]
        [JsonProperty(PropertyName = "exclusivity_enabled")]
        public bool ExclusivityEnabled { get; set; }
        [CsvHelper.Configuration.Attributes.Name("ad_prerolls_enabled")]
        [JsonProperty(PropertyName = "ad_prerolls_enabled")]
        public bool AdPrerollsEnabled { get; set; }
        [CsvHelper.Configuration.Attributes.Name("sponsorship_enabled")]
        [JsonProperty(PropertyName = "sponsorship_enabled")]
        public bool SponsorshipEnabled { get; set; }
        [CsvHelper.Configuration.Attributes.Name("channel_id")]
        [JsonProperty(PropertyName = "channel_id")]
        public string ChannelID { get; set; }
        [CsvHelper.Configuration.Attributes.Name("channel_contract_start_date")]
        [JsonProperty(PropertyName = "channel_contract_start_date")]
        public DateTime? ChannelContractStartDate { get; set; }
        [CsvHelper.Configuration.Attributes.Name("channel_contract_end_date")]
        [JsonProperty(PropertyName = "channel_contract_end_date")]
        public DateTime? ChannelContractEndDate { get; set; }
        [CsvHelper.Configuration.Attributes.Name("account_manager_map_id")]
        [JsonProperty(PropertyName = "account_manager_map_id")]
        public int AccountManagerMapID { get; set; }
        [CsvHelper.Configuration.Attributes.Name("account_manager_id")]
        [JsonProperty(PropertyName = "account_manager_id")]
        public int AccountManagerID { get; set; }
        [CsvHelper.Configuration.Attributes.Name("account_manager_ldap_name")]
        [JsonProperty(PropertyName = "account_manager_ldap_name")]
        public string AccountManagerLdapName { get; set; }
        [CsvHelper.Configuration.Attributes.Name("account_manager_first_name")]
        [JsonProperty(PropertyName = "account_manager_first_name")]
        public string AccountManagerFirstName { get; set; }
        [CsvHelper.Configuration.Attributes.Name("account_manager_last_name")]
        [JsonProperty(PropertyName = "account_manager_last_name")]
        public string AccountManagerLastName { get; set; }
        [CsvHelper.Configuration.Attributes.Name("account_manager_email")]
        [JsonProperty(PropertyName = "account_manager_email")]
        public string AccountManagerEmail { get; set; }
        [CsvHelper.Configuration.Attributes.Name("approving_manager_amazon_id")]
        [JsonProperty(PropertyName = "approving_manager_amazon_id")]
        public string ApprovingManagerAmazonID { get; set; }
        [CsvHelper.Configuration.Attributes.Name("approving_manager_name")]
        [JsonProperty(PropertyName = "approving_manager_name")]
        public string ApprovingManagerName { get; set; }
        [CsvHelper.Configuration.Attributes.Name("premium_content_creator_id")]
        [JsonProperty(PropertyName = "premium_content_creator_id")]
        public int PremiumContentCreatorID { get; set; }
        [CsvHelper.Configuration.Attributes.Name("premium_content_creator_name")]
        [JsonProperty(PropertyName = "premium_content_creator_name")]
        public string PremiumContentCreatorName { get; set; }
        [CsvHelper.Configuration.Attributes.Name("premium_content_creator_type")]
        [JsonProperty(PropertyName = "premium_content_creator_type")]
        public string PremiumContentCreatorType { get; set; }
        [CsvHelper.Configuration.Attributes.Name("is_active")]
        [JsonProperty(PropertyName = "is_active")]
        public string IsActive { get; set; }
    }
}
