﻿using Microsoft.AspNetCore.Http;
using Newtonsoft.Json;
using Resonance.Core.ConstantData.Amp;
using Resonance.Core.Helpers.ApiHelpers;
using Resonance.Core.Models.FilterModels;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Resonance.Core.Models.DatabaseModels.RequestModels
{
    public class Request
    {
        public bool CanSee(HttpContext context, string user)
        {
            if (CreatedBy != user && RevisedBy != user && !PermissionHelper.HasPermission(context, ConstantsPermissions.Amp.CanApproveRequests) && !PermissionHelper.HasPermission(context, ConstantsPermissions.Amp.CanSeeAllRequests) && RequestPrivacy != "Public")
            {
                return false;
            }
            return true;
        }

        public bool CanApprove(HttpContext context)
        {
            return PermissionHelper.HasPermission(context, ConstantsPermissions.Amp.CanApproveRequests);
        }

        public bool CanCancel(HttpContext context, string user)
        {
            string[] statuses = new string[] { RequestStatus.Submitted, RequestStatus.PendingFinalization, RequestStatus.Finalized, RequestStatus.Canceled };

            if (statuses.Contains(Status))
            {
                return CreatedBy == user || PermissionHelper.HasPermission(context, ConstantsPermissions.Amp.CanApproveRequests);
            }
            else
            {
                return PermissionHelper.HasPermission(context, ConstantsPermissions.Amp.CanApproveRequests);
            }
        }

        public bool CanDelete(HttpContext context, string user)
        {
            string[] statuses = new string[] { RequestStatus.Draft, RequestStatus.PendingFinalization, RequestStatus.Deleted };

            if (statuses.Contains(Status))
            {
                return CreatedBy == user || PermissionHelper.HasPermission(context, ConstantsPermissions.Amp.CanApproveRequests);
            }
            else
            {
                return PermissionHelper.HasPermission(context, ConstantsPermissions.Amp.CanApproveRequests);
            }
        }

        public bool CanSubmit(HttpContext context, string user)
        {
            if(Status == RequestStatus.Approved)
            {
                return CreatedBy == user || PermissionHelper.HasPermission(context, ConstantsPermissions.Amp.CanApproveRequests);
            }
            else
            {
                return PermissionHelper.HasPermission(context, ConstantsPermissions.Amp.CanApproveRequests);
            }
        }

        public bool CanFinalize(HttpContext context, string user)
        {
            if (Status == RequestStatus.PendingFinalization)
            {
                return CreatedBy == user || PermissionHelper.HasPermission(context, ConstantsPermissions.Amp.CanApproveRequests);
            }
            else
            {
                return PermissionHelper.HasPermission(context, ConstantsPermissions.Amp.CanApproveRequests);
            }
        }

        public bool CanReject(HttpContext context, string user)
        {
            if (Status == RequestStatus.PendingApproval)
            {
                return CreatedBy == user || PermissionHelper.HasPermission(context, ConstantsPermissions.Amp.CanApproveRequests);
            }
            else
            {
                return PermissionHelper.HasPermission(context, ConstantsPermissions.Amp.CanApproveRequests);
            }
        }

        [JsonProperty(PropertyName ="id")]
        public string ID { get; set; }
        [JsonProperty(PropertyName = "edit_id")]
        public string EditID { get; set; }
        [JsonProperty(PropertyName = "created_by")]
        public string CreatedBy { get; set; }
        [JsonProperty(PropertyName = "revised_by")]
        public string RevisedBy { get; set; }
        [JsonProperty(PropertyName = "name")]
        public string Name { get; set; }
        [JsonProperty(PropertyName = "created_date")]
        public DateTime CreatedDate { get; set; }
        [JsonProperty(PropertyName = "due_date")]
        public DateTime? DueDate { get; set; }
        [JsonProperty(PropertyName = "status")]
        public string Status { get; set; }
        [JsonProperty(PropertyName = "description")]
        public string Description { get; set; }
        [JsonProperty(PropertyName = "type")]
        public string Type { get; set; }
        [JsonProperty(PropertyName = "participant_count")]
        public int? ParticipantCount { get; set; }
        [JsonProperty(PropertyName = "region")]
        public string[] Region { get; set; }
        [JsonProperty(PropertyName = "language")]
        public string Language { get; set; }
        [JsonProperty(PropertyName = "country")]
        public string[] Country { get; set; }
        [JsonProperty(PropertyName = "time_required_count")]
        public float? TimeRequiredCount { get; set; }
        [JsonProperty(PropertyName = "time_required_type")]
        public string TimeRequiredType { get; set; }
        [JsonProperty(PropertyName = "public_statement")]
        public string PublicStatement { get; set; }
        [JsonProperty(PropertyName = "privacy")]
        public string RequestPrivacy { get; set; }
        [JsonProperty(PropertyName = "contact_method")]
        public string ContactMethod { get; set; }
        [JsonProperty(PropertyName = "engagement_type")]
        public string EngagementType { get; set; }
        [JsonProperty(PropertyName = "engagement_date_min")]
        public DateTime? EngagementDateMin { get; set; }
        [JsonProperty(PropertyName = "engagement_date_max")]
        public DateTime? EngagementDateMax { get; set; }
        [JsonProperty(PropertyName = "paid_opportunity")]
        public bool? PaidOpportunity { get; set; }
        [JsonProperty(PropertyName = "flood")]
        public bool? Flood { get; set; }
        [JsonIgnore]
        public string DataKey { get; set;}
        [JsonProperty(PropertyName = "filters")]
        public ListingFilter Filters { get; set; }
        [JsonProperty(PropertyName = "allow_am_suggestions")]
        public bool AllowAMSuggestions { get; set; }
    }
}
