﻿using Newtonsoft.Json;
using Resonance.Core.Models.FilterModels;
using System;
using System.Collections.Generic;
using System.Text;

namespace Resonance.Core.Models.DatabaseModels.RequestModels
{
    public class RequestChannel
    {
        [JsonProperty(PropertyName ="channel_id")]
        public int ChannelID { get; set; }
        [JsonProperty(PropertyName ="channel_login")]
        public string ChannelLogin { get; set; }
        [JsonProperty(PropertyName ="status")]
        public string Status { get; set; }
        [JsonProperty(PropertyName = "profile_image")]
        public string ProfileImage { get; set; }
        [JsonProperty(PropertyName = "comment")]
        public string Comment { get; set; }
        [JsonProperty(PropertyName = "rating")]
        public int? Rating { get; set; }
        [JsonProperty(PropertyName = "contact_info")]
        public string ContactInfo { get; set; }
        [JsonProperty(PropertyName = "creator_status")]
        public string CreatorStatus { get; set; }
        [JsonProperty(PropertyName = "response_date")]
        public DateTime? ResponseDate { get; set; }
        [JsonProperty(PropertyName = "priority")]
        public int? Priority { get; set; }
        [JsonProperty(PropertyName = "sort_order")]
        public int? SortOrder { get; set; }
        [JsonProperty(PropertyName = "hours_watched_sort")]
        public float? HoursWatchedSort { get; set; }
        [JsonProperty(PropertyName = "nomination_reason")]
        public string NominationReason { get; set; }
        [JsonProperty(PropertyName = "declined_reason")]
        public string DeclinedReason { get; set; }
    }
    public class RequestDetails
    {
        [JsonProperty(PropertyName ="request")]
        public Request Request {get;set;}
        [JsonProperty(PropertyName = "channels")]
        public List<RequestChannel> Channels { get; set; }
        [JsonProperty(PropertyName = "authorized_users")]
        public List<RequestUser> AuthorizedUsers { get; set; }
        
    }

    public class RequestUser
    {
        [JsonProperty(PropertyName = "user_id")]
        public string UserID { get; set; }
        [JsonProperty(PropertyName = "user_name")]
        public string UserName { get; set; }
    }

    public class RequestWithRevisionDetails
    {
        public RequestDetails Original { get; set; }
        public RequestDetails Revision { get; set; }
    }
}
