﻿using Newtonsoft.Json;
using System;
using static Resonance.Core.Constants;

namespace Resonance.Core.Models.DatabaseModels.TwitchUserListingModels
{
    public class TwitchUserCardQueryModel
    {
        [CsvHelper.Configuration.Attributes.Name("aggregationtype")]
        [JsonProperty(PropertyName = "aggregationtype", NullValueHandling = NullValueHandling.Ignore)]
        public AggregationType AggregationType { get; set; }
        [CsvHelper.Configuration.Attributes.Name("day")]
        [JsonProperty(PropertyName = "day", NullValueHandling = NullValueHandling.Ignore)]
        public DateTime Day { get; set; }
        [CsvHelper.Configuration.Attributes.Name("twitchuserid")]
        [JsonProperty(PropertyName = "twitchuserid", NullValueHandling = NullValueHandling.Ignore)]
        public long TwitchUserID { get; set; }
        [CsvHelper.Configuration.Attributes.Name("channelconcurrentminuteswatchedtotal")]
        [JsonProperty(PropertyName = "channelconcurrentminuteswatchedtotal", NullValueHandling = NullValueHandling.Ignore)]
        public long ChannelConcurrentMinutesWatchedTotal { get; set; }
        [CsvHelper.Configuration.Attributes.Name("maxccuhistorical")]
        [JsonProperty(PropertyName = "maxccuhistorical", NullValueHandling = NullValueHandling.Ignore)]
        public int MaxCCUHistorical { get; set; }
        [CsvHelper.Configuration.Attributes.Name("averageccu")]
        [JsonProperty(PropertyName = "averageccu", NullValueHandling = NullValueHandling.Ignore)]
        public double AverageCCU { get; set; }
        /*[CsvHelper.Configuration.Attributes.Name("channelconcurrentminutesbroadcasttotal")]
        [JsonProperty(PropertyName = "channelconcurrentminutesbroadcasttotal", NullValueHandling = NullValueHandling.Ignore)]
        public int ChannelConcurrentMinutesBroadcastTotal { get; set; }*/
        [CsvHelper.Configuration.Attributes.Name("aggregationgranularity")]
        [JsonProperty(PropertyName = "aggregationgranularity", NullValueHandling = NullValueHandling.Ignore)]
        public AggregationGranularity AggregationGranularity { get; set; }
    }
}
