﻿using Resonance.Core.Helpers.DatabaseHelpers;

namespace Resonance.Core.Models.DatabaseModels.TwitchUserListingModels
{
    public static class TwitchUserListingColumnDefinition
    {
        public static string ChannelID = "channelid";
        public static string Login = "login";
        public static string AccountManager = "accountmanager";
        public static string UserType = "usertype";
        public static string PrimaryBroadcastLanguage = "primarybroadcastlanguage";
        public static string PrimaryBroadcastCountry = "primarybroadcastcountry";
        public static string TopGameBroadcast = "topgamebroadcast";
        public static string CCUTier = "ccutier";
        public static string ChannelConcurrentsMinutesWatchedTotal = "channelconcurrentsminuteswatchedtotal";
        public static string ChannelConcurrentsMinutesBroadcastTotal = "channelconcurrentsminutesbroadcasttotal";
        public static string SubsSoldTotal = "subssoldtotal";
        public static string AverageCCU = "averageccu";
        public static string MaxCCU = "maxccu";
        public static string SubsSoldPrimeTotal = "subssoldprimetotal";
        public static string ChatMessagesTotal = "chatmessagestotal";

        public static string FollowerCountTotal = "followercounttotal";

        public static string UniqueDaysBroadcast = "uniquedaysbroadcast";
        public static string VideoPlaysTotal = "videoplaystotal";
        public static string GameCount = "gamecount";
        public static string CreatorSubRevenueTotal = "creatorsubrevenuetotal";
        public static string CreatorPrimeSubRevenueTotal = "creatorprimesubrevenuetotal";
        public static string CreatorAdRevenueTotal = "creatoradrevenuetotal";
        public static string CreatorBitsRevenueTotal = "creatorbitsrevenuetotal";
        public static string CreatorFuelRevenueTotal = "creatorfuelrevenuetotal";
        public static string CreatorBountyBoardRevenueTotal = "creatorbountyboardrevenuetotal";
        public static string CreatorRevenueTotal = "creatorrevenuetotal";
        public static string Region = "region";
        public static string ValueScoreOverallWeighted = "valuescoreoverallweighted";
        public static string MostViewedPlatform = "mostviewedplatform";
        public static string PlatformPercentWatchedOther = "platformpercentwatchedother";
        public static string PlatformPercentWatchedDesktop = "platformpercentwatcheddesktop";
        public static string PlatformPercentWatchedMobile = "platformpercentwatchedmobile";
        public static string PlatformPercentWatchedWeb = "platformpercentwatchedweb";
        public static string PlatformPercentWatchedConsole = "platformpercentwatchedconsole";
        public static string PlatformPercentWatchedChromecast = "platformpercentwatchedchromecast";
        public static string IsPremium = "ispremium";
        public static string TimsUserActionRequired = "timsuseractionrequired";

        public static string[] AllExportableColumns = new[] { ChannelID, Login, PrimaryBroadcastCountry, PrimaryBroadcastLanguage, AccountManager, UserType, TopGameBroadcast, CCUTier, AverageCCU, MaxCCU, FollowerCountTotal, SubsSoldTotal, SubsSoldPrimeTotal, UniqueDaysBroadcast, VideoPlaysTotal, GameCount, ValueScoreOverallWeighted, ChannelConcurrentsMinutesBroadcastTotal, ChannelConcurrentsMinutesWatchedTotal, ChatMessagesTotal, CreatorAdRevenueTotal, CreatorBitsRevenueTotal, CreatorBountyBoardRevenueTotal, CreatorFuelRevenueTotal, CreatorPrimeSubRevenueTotal, CreatorRevenueTotal, CreatorSubRevenueTotal, MostViewedPlatform, PlatformPercentWatchedOther, PlatformPercentWatchedMobile, PlatformPercentWatchedDesktop, PlatformPercentWatchedConsole, PlatformPercentWatchedChromecast, PlatformPercentWatchedWeb, IsPremium, TimsUserActionRequired };


        public static string[] Default()
        {
            return FieldHelper.GetFields(typeof(TwitchUserListingModel));
        }

        public static string GetCategory(string column)
        {
            switch(column)
            {
                case "channelid":
                case "login":
                case "accountmanager":
                case "usertype":
                case "primarybroadcastlanguage":
                case "primarybroadcastcountry":
                case "topgamebroadcast":
                case "ccutier":
                case "region":
                case "valuescoreoverallweighted":
                case "ispremium":
                case "timsuseractionrequired":
                    return "Channel";
                case "channelconcurrentsminuteswatchedtotal":
                case "channelconcurrentsminutesbroadcasttotal":
                case "subssoldtotal":
                case "averageccu":
                case "maxccu":
                case "subssoldprimetotal":
                case "chatmessagestotal":
                case "followercounttotal":
                case "uniquedaysbroadcast":
                case "videoplaystotal":
                case "gamecount":
                    return "Engagement";
                case "creatorsubrevenuetotal":
                case "creatorprimesubrevenuetotal":
                case "creatoradrevenuetotal":
                case "creatorbitsrevenuetotal":
                case "creatorfuelrevenuetotal":
                case "creatorbountyboardrevenuetotal":
                case "creatorrevenuetotal":
                    return "Revenue";
                case "mostviewedplatform":
                case "platformpercentwatchedother":
                case "platformpercentwatcheddesktop":
                case "platformpercentwatchedweb":
                case "platformpercentwatchedmobile":
                case "platformpercentwatchedconsole":
                case "platformpercentwatchedchromecast":
                    return "Viewership";
                default:
                    return "";
            }
        }

        
        public static string[] IndexListing()
        {
            return new string[11]
            {
                "channelid",
                "login",
                "channelconcurrentsminuteswatchedtotal",
                "channelconcurrentsminutesbroadcasttotal",
                "maxccu",
                "averageccu",
                "averageccudata",
                "minuteswatcheddata",
                "subssoldtotal",
                "profileimage",
                "region"
            };
        }
    }
}
