﻿using Newtonsoft.Json;
using System;
using static Resonance.Core.Constants;

namespace Resonance.Core.Models.DatabaseModels.TwitchUserListingModels
{
    public class TwitchUserListingModel
    {
        [CsvHelper.Configuration.Attributes.Name("mindate")]
        [JsonProperty(PropertyName = "mindate", NullValueHandling = NullValueHandling.Ignore)]
        public DateTime? MinDate { get; set; }
        [CsvHelper.Configuration.Attributes.Name("maxdate")]
        [JsonProperty(PropertyName = "maxdate", NullValueHandling = NullValueHandling.Ignore)]
        public DateTime? MaxDate { get; set; }
        [CsvHelper.Configuration.Attributes.Name("aggregationtype")]
        [JsonProperty(PropertyName = "aggregationtype", NullValueHandling = NullValueHandling.Ignore)]
        public AggregationType AggregationType { get; set; }
        [CsvHelper.Configuration.Attributes.Name("channelid")]
        [JsonProperty(PropertyName = "channelid", NullValueHandling = NullValueHandling.Ignore)]
        public long? ChannelID { get; set; }
        [CsvHelper.Configuration.Attributes.Name("login")]
        [JsonProperty(PropertyName = "login", NullValueHandling = NullValueHandling.Ignore)]
        public string Login { get; set; }
        [CsvHelper.Configuration.Attributes.Name("ccutier")]
        [JsonProperty(PropertyName = "ccutier", NullValueHandling = NullValueHandling.Ignore)]
        public string CcuTier { get; set; }
        [CsvHelper.Configuration.Attributes.Name("lastbroadcastdate")]
        [JsonProperty(PropertyName = "lastbroadcastdate", NullValueHandling = NullValueHandling.Ignore)]
        public DateTime? LastBroadcastDate { get; set; }
        [CsvHelper.Configuration.Attributes.Name("usertype")]
        [JsonProperty(PropertyName = "usertype", NullValueHandling = NullValueHandling.Ignore)]
        public string UserType { get; set; }
        [CsvHelper.Configuration.Attributes.Name("usertypechanged"), CsvHelper.Configuration.Attributes.BooleanTrueValues("t"), CsvHelper.Configuration.Attributes.BooleanFalseValues("f")]
        [JsonProperty(PropertyName = "usertypechanged", NullValueHandling = NullValueHandling.Ignore)]
        public bool? UserTypeChanged { get; set; }
        [CsvHelper.Configuration.Attributes.Name("maxccutotal")]
        [JsonProperty(PropertyName = "maxccu", NullValueHandling = NullValueHandling.Ignore)]
        public int? MaxCcu { get; set; }
        [CsvHelper.Configuration.Attributes.Name("averageccutotal")]
        [JsonProperty(PropertyName = "averageccu", NullValueHandling = NullValueHandling.Ignore)]
        public float? AverageCcu { get; set; }
        [CsvHelper.Configuration.Attributes.Name("minuteswatchedtotal")]
        [JsonProperty(PropertyName = "minuteswatchedtotal", NullValueHandling = NullValueHandling.Ignore)]
        public long? MinutesWatchedTotal { get; set; }
        [CsvHelper.Configuration.Attributes.Name("channelconcurrentminuteswatchedtotal")]
        [JsonProperty(PropertyName = "channelconcurrentsminuteswatchedtotal", NullValueHandling = NullValueHandling.Ignore)]
        public long? ChannelConcurrentsMinutesWatchedTotal { get; set; }
        [CsvHelper.Configuration.Attributes.Name("minutesbroadcasttotal")]
        [JsonProperty(PropertyName = "minutesbroadcasttotal", NullValueHandling = NullValueHandling.Ignore)]
        public long? MinutesBroadcastTotal { get; set; }
        [CsvHelper.Configuration.Attributes.Name("channelconcurrentsminutesbroadcasttotal")]
        [JsonProperty(PropertyName = "channelconcurrentsminutesbroadcasttotal", NullValueHandling = NullValueHandling.Ignore)]
        public long? ChannelConcurrentsMinutesBroadcastTotal { get; set; }
        [CsvHelper.Configuration.Attributes.Name("uniquedaysbroadcasttotal")]
        [JsonProperty(PropertyName = "uniquedaysbroadcast", NullValueHandling = NullValueHandling.Ignore)]
        public int? UniqueDaysBroadcast { get; set; }
        [CsvHelper.Configuration.Attributes.Name("followercounttotal")]
        [JsonProperty(PropertyName = "followercounttotal", NullValueHandling = NullValueHandling.Ignore)]
        public int? FollowerCountTotal { get; set; }
        [CsvHelper.Configuration.Attributes.Name("followercountchangetotal")]
        [JsonProperty(PropertyName = "followercountchangetotal", NullValueHandling = NullValueHandling.Ignore)]
        public int? FollowerCountChangeTotal { get; set; }
        [CsvHelper.Configuration.Attributes.Name("chatmessagestotal")]
        [JsonProperty(PropertyName = "chatmessagestotal", NullValueHandling = NullValueHandling.Ignore)]
        public int? ChatMessagesTotal { get; set; }
        [CsvHelper.Configuration.Attributes.Name("subssoldtotal")]
        [JsonProperty(PropertyName = "subssoldtotal", NullValueHandling = NullValueHandling.Ignore)]
        public int? SubsSoldTotal { get; set; }
        [CsvHelper.Configuration.Attributes.Name("primesubssoldtotal")]
        [JsonProperty(PropertyName = "subssoldprimetotal", NullValueHandling = NullValueHandling.Ignore)]
        public int? SubsSoldPrimeTotal { get; set; }
        [CsvHelper.Configuration.Attributes.Name("subssoldtier1total")]
        [JsonProperty(PropertyName = "subssoldtier1total", NullValueHandling = NullValueHandling.Ignore)]
        public int? SubsSoldTier1Total { get; set; }
        [CsvHelper.Configuration.Attributes.Name("subssoldtier2total")]
        [JsonProperty(PropertyName = "subssoldtier2total", NullValueHandling = NullValueHandling.Ignore)]
        public int? SubsSoldTier2Total { get; set; }
        [CsvHelper.Configuration.Attributes.Name("subssoldtier3total")]
        [JsonProperty(PropertyName = "subssoldtier3total", NullValueHandling = NullValueHandling.Ignore)]
        public int? SubsSoldTier3Total { get; set; }
        [CsvHelper.Configuration.Attributes.Name("creatorsubrevenuetotal")]
        [JsonProperty(PropertyName = "creatorsubrevenuetotal", NullValueHandling = NullValueHandling.Ignore)]
        public float? CreatorSubRevenueTotal { get; set; }
        [CsvHelper.Configuration.Attributes.Name("creatorprimesubrevenuetotal")]
        [JsonProperty(PropertyName = "creatorprimesubrevenuetotal", NullValueHandling = NullValueHandling.Ignore)]
        public float? CreatorPrimeSubRevenueTotal { get; set; }
        [CsvHelper.Configuration.Attributes.Name("creatoradrevenuetotal")]
        [JsonProperty(PropertyName = "creatoradrevenuetotal", NullValueHandling = NullValueHandling.Ignore)]
        public float? CreatorAdRevenueTotal { get; set; }
        [CsvHelper.Configuration.Attributes.Name("creatorbitsrevenuetotal")]
        [JsonProperty(PropertyName = "creatorbitsrevenuetotal", NullValueHandling = NullValueHandling.Ignore)]
        public float? CreatorBitsRevenueTotal { get; set; }
        [CsvHelper.Configuration.Attributes.Name("creatorfuelrevenuetotal")]
        [JsonProperty(PropertyName = "creatorfuelrevenuetotal", NullValueHandling = NullValueHandling.Ignore)]
        public float? CreatorFuelRevenueTotal { get; set; }
        [CsvHelper.Configuration.Attributes.Name("creatorbountyboardrevenuetotal")]
        [JsonProperty(PropertyName = "creatorbountyboardrevenuetotal", NullValueHandling = NullValueHandling.Ignore)]
        public float? CreatorBountyBoardRevenueTotal { get; set; }
        [CsvHelper.Configuration.Attributes.Name("creatorrevenuetotal")]
        [JsonProperty(PropertyName = "creatorrevenuetotal", NullValueHandling = NullValueHandling.Ignore)]
        public float? CreatorRevenueTotal { get; set; }
        [CsvHelper.Configuration.Attributes.Name("videoplaystotal")]
        [JsonProperty(PropertyName = "videoplaystotal", NullValueHandling = NullValueHandling.Ignore)]
        public long? VideoPlaysTotal { get; set; }
        [CsvHelper.Configuration.Attributes.Name("primarybroadcastlanguage")]
        [JsonProperty(PropertyName = "primarybroadcastlanguage", NullValueHandling = NullValueHandling.Ignore)]
        public string PrimaryBroadcastLanguage { get; set; }
        [CsvHelper.Configuration.Attributes.Name("primarybroadcastcountry")]
        [JsonProperty(PropertyName = "primarybroadcastcountry", NullValueHandling = NullValueHandling.Ignore)]
        public string PrimaryBroadcastCountry { get; set; }
        [CsvHelper.Configuration.Attributes.Name("topgamebroadcast")]
        [JsonProperty(PropertyName = "topgamebroadcast", NullValueHandling = NullValueHandling.Ignore)]
        public string TopGameBroadcast { get; set; }
        [CsvHelper.Configuration.Attributes.Optional]
        [JsonProperty(PropertyName = "profileimage", NullValueHandling = NullValueHandling.Ignore)]
        public string ProfileImage { get; set; }
        [CsvHelper.Configuration.Attributes.Optional]
        [JsonProperty(PropertyName = "substotal", NullValueHandling = NullValueHandling.Ignore)]
        public long? SubsTotal { get; set; }
        [CsvHelper.Configuration.Attributes.Ignore]
        [JsonProperty(PropertyName = "minuteswatcheddata", NullValueHandling = NullValueHandling.Ignore)]
        public string MinutesWatchedData { get; set; }
        [CsvHelper.Configuration.Attributes.Ignore]
        [JsonProperty(PropertyName = "averageccudata", NullValueHandling = NullValueHandling.Ignore)]
        public string AverageCcuData { get; set; }
        [CsvHelper.Configuration.Attributes.Optional]
        [JsonProperty(PropertyName = "region", NullValueHandling = NullValueHandling.Ignore)]
        public string Region { get; set; }
        [CsvHelper.Configuration.Attributes.Name("accountmanager")]
        [JsonProperty(PropertyName = "accountmanager", NullValueHandling = NullValueHandling.Ignore)]
        public string AccountManager { get; set; }
        [CsvHelper.Configuration.Attributes.Name("valuescoreoverallweighted")]
        [JsonProperty(PropertyName = "valuescoreoverallweighted", NullValueHandling = NullValueHandling.Ignore)]
        public float? ValueScoreOverallWeighted { get; set; }
        [CsvHelper.Configuration.Attributes.Ignore]
        [JsonProperty(PropertyName = "sort"), JsonIgnore]
        public int Sort { get; set; }
        [CsvHelper.Configuration.Attributes.Name("gamecount")]
        [JsonProperty(PropertyName = "gamecount", NullValueHandling = NullValueHandling.Ignore)]
        public int GameCount { get; set; }
        [CsvHelper.Configuration.Attributes.Name("mostviewedplatform")]
        [JsonProperty(PropertyName = "mostviewedplatform", NullValueHandling = NullValueHandling.Ignore)]
        public string MostViewedPlatform { get; set; }
        [CsvHelper.Configuration.Attributes.Name("platformpercentwatchedother")]
        [JsonProperty(PropertyName = "platformpercentwatchedother", NullValueHandling = NullValueHandling.Ignore)]
        public float PlatformPercentWatchedOther { get; set; }
        [CsvHelper.Configuration.Attributes.Name("platformpercentwatchedmobile")]
        [JsonProperty(PropertyName = "platformpercentwatchedmobile", NullValueHandling = NullValueHandling.Ignore)]
        public float PlatformPercentWatchedMobile { get; set; }
        [CsvHelper.Configuration.Attributes.Name("platformpercentwatchedchromecast")]
        [JsonProperty(PropertyName = "platformpercentwatchedchromecast", NullValueHandling = NullValueHandling.Ignore)]
        public float PlatformPercentWatchedChromecast { get; set; }
        [CsvHelper.Configuration.Attributes.Name("platformpercentwatchedweb")]
        [JsonProperty(PropertyName = "platformpercentwatchedweb", NullValueHandling = NullValueHandling.Ignore)]
        public float PlatformPercentWatchedWeb { get; set; }
        [CsvHelper.Configuration.Attributes.Name("platformpercentwatchedconsole")]
        [JsonProperty(PropertyName = "platformpercentwatchedconsole", NullValueHandling = NullValueHandling.Ignore)]
        public float PlatformPercentWatchedConsole { get; set; }
        [CsvHelper.Configuration.Attributes.Name("platformpercentwatcheddesktop")]
        [JsonProperty(PropertyName = "platformpercentwatcheddesktop", NullValueHandling = NullValueHandling.Ignore)]
        public float PlatformPercentWatchedDesktop { get; set; }
        [CsvHelper.Configuration.Attributes.Name("ispremium")]
        [JsonProperty(PropertyName = "ispremium", NullValueHandling = NullValueHandling.Ignore)]
        public bool IsPremium { get; set; }
        [CsvHelper.Configuration.Attributes.Name("timsuseractionrequired")]
        [JsonProperty(PropertyName = "timsuseractionrequired", NullValueHandling = NullValueHandling.Ignore)]
        public bool TimsUserActionRequired { get; set; }
    }
}
