﻿using Newtonsoft.Json;
using System.Collections.Generic;
using static Resonance.Core.Constants;

namespace Resonance.Core.Models.FilterModels
{
    public class ListingFilter
    {
        [JsonProperty(PropertyName = "limit")]
        public int Limit { get; set; } = 100;
        [JsonProperty(PropertyName = "page")]
        public int Page { get; set; } = 0;
        [JsonProperty(PropertyName = "eventtype", NullValueHandling = NullValueHandling.Ignore)]
        public AtlasInternalEventType EventType { get; set; } = AtlasInternalEventType.Unknown;
        [JsonProperty(PropertyName = "aggtype", NullValueHandling = NullValueHandling.Ignore)]
        public AggregationType AggregateType { get; set; } = AggregationType.ThirtyDay;
        [JsonProperty(PropertyName = "req-cols")]
        public string[] Columns { get; set; }
        [JsonProperty(PropertyName = "req-cols-daily")]
        public string[] DailyColumns { get; set; }
        [JsonProperty(PropertyName = "filters")]
        public IEnumerable<QueryFilter> QueryFilters { get; set; }
        /// <summary>
        /// Key :: String :: Name of external query to use, must match whitelist exactly
        /// </summary>
        [JsonProperty("external-filters")]
        public Dictionary<string, List<ExternalQueryFilter>> ExternalQueryFilters { get; set; }
        [JsonProperty(PropertyName = "sortdata")]
        public SortFilter[] SortOrder { get; set; }
        [JsonProperty(PropertyName = "active_only")]
        public bool ActiveOnly { get; set; } = true;
    }
}
