﻿using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc.Infrastructure;
using Resonance.Core.Helpers.ApiHelpers;
using Resonance.Core.Helpers.LoggingHelpers;
using Resonance.Core.Services.ActivityLoggerService;
using Resonance.Core.Services.ColumnFilterService;
using System;
using System.Collections.Generic;
using System.Linq;

namespace Resonance.Core.Models.FilterModels
{
    public static class ListingFilters
    {
        public static void FilterOutRestrictedColumns(this ListingFilter filter, HttpRequest request, IColumnFilterService service, IActivityLoggerService activityLoggerService, string profileName, IActionContextAccessor actionContextAccessor)
        {
            try
            {                
                IList<string> permissions = PermissionHelper.GetPermissions(request.HttpContext);
                service.FilterOutRestrictedColumns(permissions ?? new List<string>(), filter, profileName, activityLoggerService, actionContextAccessor);
            }
            catch (Exception ex)
            {
                Log.Error(ex);
            }
        }

        public static IList<string> FilterOutRestrictedColumns(this IEnumerable<string> columns, HttpRequest request, IColumnFilterService service, IActivityLoggerService activityLoggerService, string profileName, IActionContextAccessor actionContextAccessor)
        {            
            IList<string> permissions = PermissionHelper.GetPermissions(request.HttpContext);
            return service.FilterOutRestrictedColumns(permissions ?? new List<string>(), columns.ToList(), profileName, activityLoggerService, actionContextAccessor);

        }
    }
}
