﻿using Newtonsoft.Json;
using System;
using System.Collections.Generic;
using static Resonance.Core.Constants;

namespace Resonance.Core.Models.FilterModels
{
    public class QueryFilter
    {
        /// <summary>
        /// Specify what filter should be applied
        /// </summary>
        [JsonProperty(PropertyName = "filter-type", NullValueHandling = NullValueHandling.Include)]
        public FilterType FilterType { get; set; }
        /// <summary>
        /// Database Column-Key used for filter. This must match the Json Property Name on the target model
        /// </summary>
        [JsonProperty(PropertyName = "key", NullValueHandling = NullValueHandling.Include)]
        public string Key { get; set; }
        /// <summary>
        /// Should the range include or exclude 'v2' (Include is Less Than Or Equal To)
        /// </summary>
        [JsonProperty(PropertyName = "is-inclusive", NullValueHandling = NullValueHandling.Include)]
        public bool IsInclusive { get; set; }
        [JsonProperty(PropertyName = "is-case-sensitive", NullValueHandling = NullValueHandling.Include)]
        public bool IsCaseSensitive { get; set; }
        /// <summary>
        /// REQUIRED: Value to compare against (or start at for Range)
        /// </summary>
        [JsonProperty(PropertyName = "v1", NullValueHandling = NullValueHandling.Include)]
        public dynamic Value { get; set; }
        /// <summary>
        /// ONLY REQUIRED FOR RANGE: Value to end at
        /// </summary>
        [JsonProperty(PropertyName = "v2", NullValueHandling = NullValueHandling.Include)]
        public dynamic Value2 { get; set; }
        [JsonProperty(PropertyName = "a1", NullValueHandling = NullValueHandling.Include)]
        public dynamic[] ValueArray { get; set; }
    }
}
