﻿using Newtonsoft.Json;
using System;
using System.Collections.Generic;
using System.Text;

namespace Resonance.Core.Models.MetaDataModels
{
    public class CloudwatchMetricModel
    {
        [JsonProperty(PropertyName = "namespace", Order = 0, NullValueHandling = NullValueHandling.Include)]
        public string Namespace { get; set; }
        [JsonProperty(PropertyName = "key", Order = 1, NullValueHandling = NullValueHandling.Include)]
        public string Key { get; set; }
        [JsonProperty(PropertyName = "value", Order = 2, NullValueHandling = NullValueHandling.Include)]
        public double Value { get; set; }
        [JsonProperty(PropertyName = "http_path", Order = 3, NullValueHandling = NullValueHandling.Include)]
        public string HttpPath { get; set; }
        [JsonProperty(PropertyName = "http_method", Order = 4, NullValueHandling = NullValueHandling.Include)]
        public string HttpMethod { get; set; }
        [JsonProperty(PropertyName = "http_status", Order = 5, NullValueHandling = NullValueHandling.Include)]
        public string HttpStatus { get; set; }
        [JsonProperty(PropertyName = "user_id", Order = 6, NullValueHandling = NullValueHandling.Include)]
        public string UserID { get; set; }
        [JsonProperty(PropertyName = "app_version", Order = 7, NullValueHandling = NullValueHandling.Include)]
        public string AppVersion { get; set; }
        [JsonProperty(PropertyName = "date_stamp", Order = 8, NullValueHandling = NullValueHandling.Include)]
        public string Datestamp { get; set; }
        [JsonProperty(PropertyName = "time_stamp", Order = 9, NullValueHandling = NullValueHandling.Include)]
        public DateTime Timestamp { get; set; }
        [JsonProperty(PropertyName = "host", Order =10, NullValueHandling = NullValueHandling.Include)]
        public string Host { get; set; }
        [JsonProperty(PropertyName = "tracking_id", Order = 11, NullValueHandling = NullValueHandling.Include)]
        public string TrackingID { get; set; }
        [JsonProperty(PropertyName = "user_ip", Order = 12, NullValueHandling = NullValueHandling.Include)]
        public string UserIP { get; set; }
        [JsonProperty(PropertyName = "user_agent", Order = 13, NullValueHandling = NullValueHandling.Include)]
        public string UserAgent { get; set; }
    }
}
