﻿using Newtonsoft.Json;
using System.Collections.Generic;

namespace Resonance.Core.Models.ServiceModels.AtlasModels
{
    public class TopicListEntry
    {
        [JsonProperty(PropertyName = "topic")]
        public string Topic { get; set; }
        [JsonProperty(PropertyName = "topic_id")]
        public int TopicID { get; set; }
        [JsonProperty(PropertyName = "sub_topics")]
        public List<string> SubTopics { get; set; }
        [JsonProperty(PropertyName = "formats")]
        public List<FormatListEntry> Formats { get; set; }
    }

    public class FormatListEntry
    {
        [JsonProperty(PropertyName = "format")]
        public string Format { get; set; }
        [JsonProperty(PropertyName = "format_id")]
        public int FormatID { get; set; }
        [JsonProperty(PropertyName = "sub_formats")]
        public List<string> SubFormats { get; set; }
    }



    public class TopicFormatModel
    {
        [JsonProperty(PropertyName = "topic_auto_id")]
        public int TopicAutoID { get; set; }

        [JsonProperty(PropertyName = "topic_id")]
        public int TopicID { get; set; }
        [JsonProperty(PropertyName = "topic_name")]
        public string TopicName { get; set; }
        [JsonProperty(PropertyName = "topic_description")]
        public string TopicDescription { get; set; }
        [JsonProperty(PropertyName = "is_gaming")]
        public bool IsGaming { get; set; }
        [JsonProperty(PropertyName = "sub_topic_auto_id")]
        public int? SubTopicAutoID { get; set; }
        [JsonProperty(PropertyName = "sub_topic_id")]
        public int? SubTopicID { get; set; }
        [JsonProperty(PropertyName = "sub_topic_name")]
        public string SubTopicName { get; set; }
        [JsonProperty(PropertyName = "sub_topic_description")]
        public string SubTopicDescription { get; set; }
        [JsonProperty(PropertyName = "format_auto_id")]
        public int? FormatAutoID { get; set; }
        [JsonProperty(PropertyName = "format_id")]
        public int? FormatID { get; set; }
        [JsonProperty(PropertyName = "format_name")]
        public string FormatName { get; set; }
        [JsonProperty(PropertyName = "format_description")]
        public string FormatDescription { get; set; }
        [JsonProperty(PropertyName = "sub_format_auto_id")]
        public int? SubFormatAutoID { get; set; }
        [JsonProperty(PropertyName = "sub_format_id")]
        public int? SubFormatID { get; set; }
        [JsonProperty(PropertyName = "sub_format_name")]
        public string SubFormatName { get; set; }
        [JsonProperty(PropertyName = "sub_format_description")]
        public string SubFormatDescription { get; set; }
    }
}
