﻿using Resonance.Core.Helpers.FilterHelpers;
using System;
using System.Diagnostics;
using System.Linq;
using System.Reflection;

namespace Resonance.Core.Models.ServiceModels.ExplorerModels
{
    public class ResonanceTrackedClassModel
    {
        public Type ClassType { get; set; }
        public ResonanceFieldModel[] Fields { get; set; }

        public ResonanceTrackedClassModel(Type objType)
        {
            try
            {
                ClassType = objType;
                var properties = ClassType.GetProperties(BindingFlags.Public | BindingFlags.Instance);
                Fields = properties.Select(x => new ResonanceFieldModel()
                {
                    Name = x.Name,
                    ValidFilters = FilterHelperMysql.DetermineValidFilters(x.GetMethod.ReturnType),
                    FieldType = x.GetMethod.ReturnType,
                    CustomAttributes = x.CustomAttributes.ToArray()
                }).ToArray();
            }
            catch (Exception ex)
            {
                Debug.Print(ex.ToString());
            }
        }
    }
}
