﻿using Resonance.Core.Models.ApiModels;
using Newtonsoft.Json;
using System;
using static Resonance.Core.Constants;

namespace Resonance.Core.Models.ServiceModels.TwitchModels
{
    public class TwitchUserListModel : IBatchable
    {
        [JsonProperty(PropertyName = "data")]
        public TwitchUserModel[] Data { get; set; }
        /// <summary>
        /// ConstantsWorker.WorkerIdentifier;
        /// </summary>
        [JsonIgnore] public string WorkerIdentifier { get; set; }
        /// <summary>
        /// Batch count for bulk processing - managed by calling process
        /// </summary>
        [JsonIgnore] public string BatchID { get; set; }
        /// <summary>
        /// Call the batch start timestamp with extension `.ToRedshiftDate()`
        /// </summary>
        [JsonIgnore] public DateTime BatchStart { get; set; }
    }

    public class TwitchUserModel
    {
        [JsonProperty(PropertyName = "twitch_user_id")]
        public long TwitchUserID { get; set; }
        [JsonProperty(PropertyName = "twitch_login")]
        public string TwitchLogin { get; set; }
        [JsonProperty(PropertyName = "is_active")]
        public bool IsActive { get; set; }
        [JsonProperty(PropertyName = "inactive_reason")]
        public TwitchInactiveStatus InactiveReason { get; set; }

        public override bool Equals(object obj)
        {
            var item = obj as TwitchUserModel;

            if (item == null)
            {
                return false;
            }

            return this.TwitchUserID.Equals(item.TwitchUserID);
        }

        public override int GetHashCode()
        {
            return this.TwitchUserID.GetHashCode();
        }
    }
}
