﻿using Resonance.Core.Models.ApiModels;
using Newtonsoft.Json;
using System;

namespace Resonance.Core.Models.ServiceModels.TwitchModels
{
    public class TwitchVerifiedLinkListModel : IBatchable
    {
        [JsonProperty(PropertyName = "data")]
        public TwitchVerifiedLinkModel[] Data { get; set; }
        /// <summary>
        /// ConstantsWorker.WorkerIdentifier;
        /// </summary>
        [JsonIgnore] public string WorkerIdentifier { get; set; }
        /// <summary>
        /// Batch count for bulk processing - managed by calling process
        /// </summary>
        [JsonIgnore] public string BatchID { get; set; }
        /// <summary>
        /// Call the batch start timestamp with extension `.ToRedshiftDate()`
        /// </summary>
        [JsonIgnore] public DateTime BatchStart { get; set; }
    }

    /// <summary>
    /// Twitch Verified Link Model - Maps to table dbo.YoutubeTwitchVerifiedLink
    /// </summary>
    public class TwitchVerifiedLinkModel
    {        
        /// <summary>
        /// Twitch User ID
        /// </summary>
        [JsonProperty(PropertyName = "twitch_user_id")]
        public long? TwitchUserID { get; set; } = null;
        /// <summary>
        /// Youtube Tag - Begins with 'UC'
        /// </summary>
        [JsonProperty(PropertyName = "youtube_tag")]
        public string YoutubeTag { get; set; } = null;
        /// <summary>
        /// Twitch Login - This may or may not be known. (Lookups happen apart from user id discovery)
        /// </summary>
        [JsonProperty(PropertyName = "twitch_login")]
        public string TwitchLogin { get; set; } = null;
        /// <summary>
        /// User who created the link. 'System' is a special case
        /// </summary>
        [JsonProperty(PropertyName = "added_by")]
        public string AddedBy { get; set; } = null;
        /// <summary>
        /// Timestamp for last edited value
        /// </summary>
        [JsonProperty(PropertyName = "last_updated")]
        public DateTime LastUpdated { get; set; } = DateTime.UtcNow;

        public override bool Equals(object obj)
        {
            var item = obj as TwitchVerifiedLinkModel;

            if (item == null)
            {
                return false;
            }

            return this.YoutubeTag.Equals(item.TwitchUserID);
        }

        public override int GetHashCode()
        {
            return this.YoutubeTag.GetHashCode();
        }
    }
}
