﻿using Newtonsoft.Json;

namespace Resonance.Core.Models.ServiceModels.TwitchUploadServiceModels
{
    /// <summary>
    /// Describes the callback the upload service should make when postprocessing is complete.
    /// </summary>
    public class CallbackModel
    {
        /// <summary>
        /// The ARN of an SNS topic where the callback should be made. Pass "default" to use the no-op topic which marks the status as COMPLETE.
        /// </summary>
        [JsonProperty(PropertyName = "sns_topic_arn", Order = 1)]
        public string SnsTopicArn { get; set; }
        /// <summary>
        /// Arbitrary binary data that should be included with the callback. Can usually be replaced by the "data_str" field below.
        /// </summary>
        [JsonProperty(PropertyName = "data", Order = 2)]
        public byte[] Data { get; set; }
        /// <summary>
        /// Default is not to send any events. Pass "default" for topic to be upload.{{upload_id}}.
        /// </summary>
        [JsonProperty(PropertyName = "pubsub_topic", Order = 3)]
        public string PubSubTopic { get; set; }
        /// <summary>
        /// A human-readable string that can included with the callback. For binary data use the "data" field above.
        /// </summary>
        [JsonProperty(PropertyName = "data_str", Order = 4)]
        public string DataString { get; set; }
    }
}
