﻿using Newtonsoft.Json;

namespace Resonance.Core.Models.ServiceModels.TwitchUploadServiceModels
{
    /// <summary>
    /// A constraint is a test on a single number: =, <, <=, >, >=
    /// All constraints must be satisfied. Specifying redundant or mutually exclusive constraints
    /// is illegal.
    /// </summary>
    public class ConstraintModel
    {
        /// <summary>
        /// The value to be tested against
        /// </summary>
        [JsonProperty(PropertyName = "value", Order = 1)]
        public double Value { get; set; }
        /// <summary>
        /// This string must be one of: =, &lt;, &lt;=, &gt;, &gt;=
        /// </summary>
        [JsonProperty(PropertyName = "test", Order = 2)]
        public string Test { get; set; }
    }
}
