﻿using Newtonsoft.Json;
using System;
using System.Collections.Generic;
using System.Text;

namespace Resonance.Core.Models.ServiceModels.TwitchUploadServiceModels
{
    public class OutputModel
    {
        /// <summary>
        /// Transformations are applied in order.
        /// </summary>
        [JsonProperty(PropertyName = "transformations", Order = 1)]
        public List<TransformationModel> Transformations { get; set; }
        /// <summary>
        /// PostValidation happens after all transformations are complete. If a PostValidation fails, the
        /// file will not be moved out of the ingest bucket.
        /// </summary>
        [JsonProperty(PropertyName = "post_validation", Order = 2)]
        public ValidationModel PostValidation { get; set; }
        /// <summary>
        /// Describes how to name this output file, especially useful in the case of multiple outputs.
        /// If this is unset, the default is "{{UploadID}}".
        /// Available templates:
        /// - {{UploadID}}
        /// - {{Extension}} given by the Transcode Validation or else empty.
        /// - {{Dimensions}} applicable to images, available whether or not there is a resizing
        /// transformation.
        /// </summary>
        [JsonProperty(PropertyName = "name", Order = 3)]
        public string Name { get; set; }
        /// <summary>
        /// Permissions determines the file permissions on the final upload. The default is to use the aws
        /// "canned" acl "bucket-owner-full-control" to give the feature service full access to the file.
        /// Bucket policies can be used to further control the permissions on the file. If this parameter
        /// is nonempty, "bucket-owner-full-control" will not be used, and instead the feature service
        /// should be explicity granted full control by setting GrantFullControl to "id=ACCOUNT_ID",
        /// where ACCOUNT_ID is the Canonical User ID of the feature service's aws account
        /// </summary>
        [JsonProperty(PropertyName = "permissions", Order = 4)]
        public PermissionsModel Permissions { get; set; }
        /// <summary>
        /// Decides if a file being uploaded should be processed as animation.
        /// </summary>
        [JsonProperty(PropertyName = "allow_animation", Order = 5)]
        public bool AllowAnimation { get; set; }
        /// <summary>
        /// Timeout for GIF transformations, in milliseconds. The default is ten seconds.
        // This timeout is only enforced for transforming animated images while retaining animation.
        // Static images have significantly better performance.
        /// </summary>
        [JsonProperty(PropertyName = "GIF_transformation_timeout", Order = 6)]
        public uint GifTransformationTimeout { get; set; }
    }
}
