﻿using Newtonsoft.Json;

namespace Resonance.Core.Models.ServiceModels.TwitchUploadServiceModels
{
    /// <summary>
    /// Determines the explicit file permissions on the final upload. Default is the aws
    /// "canned" acl "bucket-owner-full-control". Syntax for these fields is the same as aws:
    /// they must start with 'id=' or 'uri=', whitespace is allowed, and multiple grantees can
    /// be specified using commas.
    /// For more information, visit http://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html
    /// For a syntax example, visit http://docs.aws.amazon.com/cli/latest/reference/s3api/put-object-acl.html#examples
    /// </summary>
    public class PermissionsModel
    {
        /// <summary>
        /// Grantee to be given full control. If this is set, it should be of the form:
        /// "id=ACCOUNT_ID" where ACCOUNT_ID is the Canonical User ID of the feature service's aws account
        /// </summary>
        [JsonProperty(PropertyName = "grant_full_control", Order = 1)]
        public string GrantFullControl { get; set; }
        /// <summary>
        /// Grantee to be given read permissions. To make the file publicly readable,
        /// use the string: "uri=http://acs.amazonaws.com/groups/global/AllUsers"
        /// </summary>
        [JsonProperty(PropertyName = "grant_read", Order = 2)]
        public string GrantRead { get; set; }
    }
}
