﻿using Newtonsoft.Json;
using System;
using System.Collections.Generic;
using System.Text;

namespace Resonance.Core.Models.ServiceModels.TwitchUploadServiceModels
{
    /// <summary>
    /// Transcode an image into the given format. Quality is only relevant for jpeg encoding and will
    /// be ignored for other types.
    /// "png", "jpg"/"jpeg" and "gif" are supported.
    /// </summary>
    public class TranscodeModel
    {
        [JsonProperty(PropertyName = "format", Order = 1)]
        public string Format { get; set; }
        [JsonProperty(PropertyName = "quality", Order = 2)]
        public uint Quality { get; set; }
        [JsonProperty(PropertyName = "remove_alpha", Order = 3)]
        public Constants.TwitchUploadServiceRemoveAlpha RemoveAlpha { get; set; }
    }
}
