﻿using Newtonsoft.Json;
using System;
using System.Collections.Generic;
using System.Text;

namespace Resonance.Core.Models.ServiceModels.TwitchUploadServiceModels
{
    public class UploadRequestModel
    {
        /// <summary>
        /// Defines one or more output files. At the very least, an output filename must be given so
        /// we know where to put the file once it's been uploaded. Other things that can separate one
        /// output from another are the transformations that are done to each one. For example, one
        /// output may be the full-size image that was uploaded and another could be a smaller
        /// thumbnail.
        /// </summary>
        [JsonProperty(PropertyName = "outputs", Order = 1)]
        public List<OutputModel> Outputs { get; set; }
        /// <summary>
        /// PreValidations are run before any postprocessing happens. If an upload fails PreValidation
        /// we won't even try to postprocess it.
        /// There are default constraints for file size and image size. To override the defaults,
        /// specify an explicit prevalidation.
        /// The default file size is 20 MB and the default image size is < 10000x10000.
        /// </summary>
        [JsonProperty(PropertyName = "pre_validation", Order = 3)]
        public ValidationModel PreValidation { get; set; }
        /// <summary>
        /// An S3 URL of the format s3://bucketname/path the caller wishes to upload the file to.
        /// </summary>
        [JsonProperty(PropertyName = "output_prefix", Order = 4)]
        public string OutputPrefix { get; set; }
        /// <summary>
        /// A description of the callback that the upload service should make when postprocessing is
        /// complete.
        /// </summary>
        [JsonProperty(PropertyName = "callback", Order = 5)]
        public CallbackModel Callback { get; set; }
        /// <summary>
        /// Monitoring methods through which the feature service will receive information about this upload.
        /// Supported methods are SNS, grafana, and rollbar. Grafana publishes timing information for both
        /// success and failure, SNS and rollbar report error information on failure.
        /// </summary>
        [JsonProperty(PropertyName = "monitoring", Order = 6)]
        public MonitoringModel Monitoring { get; set; }
    }
}
