﻿using Newtonsoft.Json;
using System;
using System.Collections.Generic;
using System.Text;

namespace Resonance.Core.Models.ServiceModels.TwitchUploadServiceModels
{
    /// <summary>
    /// Since it doesn't make sense to have multiple types of the same validation, instead of
    /// repeating a oneof, add as many Validations to one message as are relevant.
    /// </summary>
    public class ValidationModel
    {
        /// <summary>
        /// File sizes can be specified with common suffixes like "1GB" or "3 mb". Case doesn't matter
        /// and the letter 'B' always means bytes not bits. We will only process files smaller than 5GB.
        /// File size limits larger than than this are illegal.
        /// This limit change in the future if there is sufficient need.
        /// </summary>
        [JsonProperty(PropertyName = "file_size_less_than", Order = 1)]
        public string FileSizeLessThan { get; set; }
        /// <summary>
        /// Image formats only. The string "image" will match all valid images.
        /// </summary>
        [JsonProperty(PropertyName = "format", Order = 2)]
        public string Format { get; set; }
        /// <summary>
        /// Require an incoming image to have a particular aspect ratio (width/height).
        /// This is a convenience parameter for aspect_ratio_constraint with equality.
        /// </summary>
        [JsonProperty(PropertyName = "aspect_ratio", Order = 3)]
        public double AspectRatio { get; set; }
        /// <summary>
        /// Require an image to be larger than this size (inclusive).
        /// This is a convenience parameter for width and height constraints with >=.
        /// </summary>
        [JsonProperty(PropertyName = "minimum_size", Order = 4)]
        public DimensionsModel MinimumSize { get; set; }
        /// <summary>
        /// Require an image to be smaller than this size (inclusive).
        /// This is a convenience parameter for width and height constraints with <=.
        /// </summary>
        [JsonProperty(PropertyName = "maximum_size", Order = 5)]
        public DimensionsModel MaximumSize { get; set; }
        /// <summary>
        /// Numerical constraints on aspect ratio (width/height).
        /// </summary>
        [JsonProperty(PropertyName = "aspect_ratio_constraints", Order = 6)]
        public List<ConstraintModel> AspectRatioConstraints { get; set; }
        /// <summary>
        /// Numerical constraints on image width
        /// </summary>
        [JsonProperty(PropertyName = "width_constraints", Order = 7)]
        public List<ConstraintModel> WidthConstraints { get; set; }
        /// <summary>
        /// Numerical constraints on image height
        /// </summary>
        [JsonProperty(PropertyName = "height_constraints", Order = 8)]
        public List<ConstraintModel> HeightConstraints { get; set; }
    }
}
