﻿using System;
using System.ComponentModel.DataAnnotations;
using static Resonance.Core.Extensions.StringExtensions;

namespace Resonance.Core.Models.SlaModels
{
    public class SlaRequestModel
    {
        [Required]
        public bool AuthRequired { get; set; }
        [Required]
        public string AuthKey { get; set; }
        public dynamic Data { get; set; }
        [Required, Range(minimum: 1, maximum: Int32.MaxValue)]
        public int Iterations { get; set; }
        [Required]
        [StringRange(AllowableValues = new[] { "GET", "POST" }, ErrorMessage = "Gender must be either 'GET' or 'POST'.")]
        public string MethodType { get; set; }
    }
}
